/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceExceptionHandlerImpl
implements PersistenceExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceExceptionHandlerImpl.class);
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final Set<String> prevFailedMementoGenerators = Sets.newConcurrentHashSet();
    private final Set<String> prevFailedPersisters = Sets.newConcurrentHashSet();

    public static Builder builder() {
        return new Builder();
    }

    public PersistenceExceptionHandlerImpl(Builder builder) {
    }

    public void stop() {
        this.active.set(false);
    }

    public void onGenerateMementoFailed(BrooklynObjectType type, BrooklynObject instance, Exception e) {
        String errmsg = "generate memento for " + type + " " + instance.getClass().getName() + "(" + instance.getId() + ")";
        this.onErrorImpl(errmsg, e, this.prevFailedMementoGenerators.add(instance.getId()));
    }

    public void onPersistMementoFailed(Memento memento, Exception e) {
        String errmsg = "persist for " + memento.getClass().getSimpleName() + " " + memento.getType() + "(" + memento.getId() + ")";
        this.onErrorImpl(errmsg, e, this.prevFailedPersisters.add(memento.getId()));
    }

    public void onPersistRawMementoFailed(BrooklynObjectType type, String id, Exception e) {
        String errmsg = "persist for " + type + " (" + id + ")";
        this.onErrorImpl(errmsg, e, this.prevFailedPersisters.add(id));
    }

    public void onDeleteMementoFailed(String id, Exception e) {
        String errmsg = "delete for memento " + id;
        this.onErrorImpl(errmsg, e, this.prevFailedPersisters.add(id));
    }

    public void onUpdatePlaneIdFailed(String planeId, Exception e) {
        String errmsg = "init planeId " + planeId;
        String prevFailedId = (String)MoreObjects.firstNonNull((Object)planeId, (Object)"null-plane-id");
        this.onErrorImpl(errmsg, e, this.prevFailedPersisters.add(prevFailedId));
    }

    protected void onErrorImpl(String errmsg, Exception e, boolean isNew) {
        Exceptions.propagateIfFatal((Throwable)e);
        if (this.isActive()) {
            if (!isNew) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Repeating problem: " + errmsg, (Throwable)e);
                }
            } else {
                LOG.warn("Problem persisting (ignoring): " + errmsg, (Throwable)e);
            }
        } else if (!isNew) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Repeating problem: " + errmsg + "; but no longer active (ignoring)", (Throwable)e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Problem: " + errmsg + "; but no longer active (ignoring)", (Throwable)e);
        }
    }

    protected boolean isActive() {
        return this.active.get();
    }

    public static class Builder {
        public PersistenceExceptionHandler build() {
            return new PersistenceExceptionHandlerImpl(this);
        }
    }
}

