/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;

public abstract class RegisteredTypeKindVisitor<T> {
    public T visit(BrooklynTypeRegistry.RegisteredTypeKind kind) {
        if (kind == null) {
            return this.visitNull();
        }
        switch (kind) {
            case SPEC: {
                return this.visitSpec();
            }
            case BEAN: {
                return this.visitBean();
            }
            case UNRESOLVED: {
                return this.visitUnresolved();
            }
        }
        throw new IllegalStateException("Unexpected registered type kind: " + kind);
    }

    protected T visitNull() {
        throw new NullPointerException("Registered type kind must not be null");
    }

    protected abstract T visitSpec();

    protected abstract T visitBean();

    protected abstract T visitUnresolved();
}

