/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.localhost;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.location.AddressableLocation;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.BasicOsDetails;
import org.apache.brooklyn.core.location.HasSubnetHostname;
import org.apache.brooklyn.core.location.geo.HostGeoInfo;
import org.apache.brooklyn.core.mgmt.persist.FileBasedObjectStore;
import org.apache.brooklyn.core.mgmt.persist.LocationWithObjectStore;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.location.byon.FixedListMachineProvisioningLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.BrooklynNetworkUtils;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.internal.ssh.process.ProcessTool;
import org.apache.brooklyn.util.core.mutex.MutexSupport;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostMachineProvisioningLocation
extends FixedListMachineProvisioningLocation<SshMachineLocation>
implements AddressableLocation,
LocationWithObjectStore {
    private static final Logger LOG = LoggerFactory.getLogger(LocalhostMachineProvisioningLocation.class);
    public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newConfigKeyWithDefault(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, true);
    @SetFromFlag(value="count")
    int initialCount;
    @SetFromFlag
    Boolean canProvisionMore;
    @SetFromFlag
    InetAddress address;
    private static Set<Integer> portsInUse = Sets.newLinkedHashSet();
    private static HostGeoInfo cachedHostGeoInfo;

    @VisibleForTesting
    public static void clearStaticData() {
        portsInUse.clear();
        cachedHostGeoInfo = null;
    }

    public LocalhostMachineProvisioningLocation() {
        this(Maps.newLinkedHashMap());
    }

    @Deprecated
    public LocalhostMachineProvisioningLocation(Map<?, ?> properties) {
        super(properties);
    }

    public LocalhostMachineProvisioningLocation(String name) {
        this(name, 0);
    }

    public LocalhostMachineProvisioningLocation(String name, int count) {
        this((Map<?, ?>)MutableMap.of((Object)"name", (Object)name, (Object)"count", (Object)count));
    }

    public static LocationSpec<LocalhostMachineProvisioningLocation> spec() {
        return LocationSpec.create(LocalhostMachineProvisioningLocation.class);
    }

    @Override
    public LocalhostMachineProvisioningLocation configure(Map<?, ?> flags) {
        super.configure((Map)flags);
        if (!JavaGroovyEquivalents.groovyTruth((String)this.getDisplayName())) {
            this.setDisplayName("localhost");
        }
        if (!JavaGroovyEquivalents.groovyTruth((Object)this.address)) {
            this.address = LocalhostMachineProvisioningLocation.getLocalhostInetAddress();
        }
        if (this.canProvisionMore == null) {
            this.canProvisionMore = this.initialCount > 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        if (this.getHostGeoInfo() == null) {
            if (cachedHostGeoInfo == null) {
                cachedHostGeoInfo = HostGeoInfo.fromLocation(this);
            }
            this.setHostGeoInfo(cachedHostGeoInfo);
        }
        if (this.initialCount > this.getMachines().size()) {
            this.provisionMore(this.initialCount - this.getMachines().size());
        }
        if (this.getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR) == null && (this.getManagementContext() == null || this.getManagementContext().getConfig().getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR) == null)) {
            this.config().set(BrooklynConfigKeys.ONBOX_BASE_DIR, "/tmp/brooklyn-" + Os.user());
        }
        return this;
    }

    public static InetAddress getLocalhostInetAddress() {
        return BrooklynNetworkUtils.getLocalhostInetAddress();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean canProvisionMore() {
        return this.canProvisionMore;
    }

    @Override
    protected void provisionMore(int size, Map<?, ?> flags) {
        for (int i = 0; i < size; ++i) {
            MutableMap flags2 = MutableMap.builder().putAll(flags).put((Object)"address", (Object)(this.address != null ? this.address : LocalhostMachineProvisioningLocation.getLocalhostInetAddress())).build();
            for (ConfigKey.HasConfigKey<?> k : SshMachineLocation.ALL_SSH_CONFIG_KEYS) {
                if (!this.config().getRaw(k).isPresent()) continue;
                flags2.put(k, this.config().get(k));
            }
            if (this.isManaged()) {
                this.addChild((LocationSpec)LocationSpec.create(LocalhostMachine.class).configure((Map)flags2));
                continue;
            }
            this.addChild(new LocalhostMachine((Map<?, ?>)flags2));
        }
    }

    public static boolean obtainSpecificPort(InetAddress localAddress, int portNumber) {
        return LocalhostMachineProvisioningLocation.obtainSpecificPort(localAddress, portNumber, false);
    }

    public static synchronized boolean obtainSpecificPort(InetAddress localAddress, int portNumber, Boolean reuseAddr) {
        if (portsInUse.contains(portNumber)) {
            return false;
        }
        if (!LocalhostMachineProvisioningLocation.checkPortAvailable(localAddress, portNumber, reuseAddr)) {
            return false;
        }
        portsInUse.add(portNumber);
        return true;
    }

    public static boolean checkPortAvailable(InetAddress localAddress, int portNumber) {
        return LocalhostMachineProvisioningLocation.checkPortAvailable(localAddress, portNumber, false);
    }

    public static boolean checkPortAvailable(InetAddress localAddress, int portNumber, Boolean reuseAddr) {
        if (portNumber < 1024) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping system availability check for privileged localhost port " + portNumber);
            }
            return true;
        }
        return Networking.isPortAvailable((InetAddress)localAddress, (int)portNumber, (Boolean)reuseAddr);
    }

    public static int obtainPort(PortRange range) {
        return LocalhostMachineProvisioningLocation.obtainPort(range, false);
    }

    public static int obtainPort(PortRange range, Boolean reuseAddr) {
        return LocalhostMachineProvisioningLocation.obtainPort(LocalhostMachineProvisioningLocation.getLocalhostInetAddress(), range, reuseAddr);
    }

    public static int obtainPort(InetAddress localAddress, PortRange range) {
        return LocalhostMachineProvisioningLocation.obtainPort(localAddress, range, false);
    }

    public static int obtainPort(InetAddress localAddress, PortRange range, Boolean reuseAddr) {
        Iterator iterator = range.iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            if (!LocalhostMachineProvisioningLocation.obtainSpecificPort(localAddress, p, reuseAddr)) continue;
            return p;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("unable to find port in {} on {}; returning -1", (Object)range, (Object)localAddress);
        }
        return -1;
    }

    public static synchronized void releasePort(InetAddress localAddress, int portNumber) {
        portsInUse.remove(portNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(SshMachineLocation machine) {
        LocalhostMachine localMachine = (LocalhostMachine)machine;
        LinkedHashSet portsObtained = Sets.newLinkedHashSet();
        Object object = localMachine.portsObtained;
        synchronized (object) {
            portsObtained.addAll(localMachine.portsObtained);
        }
        super.release(machine);
        object = portsObtained.iterator();
        while (object.hasNext()) {
            int p = (Integer)object.next();
            LocalhostMachineProvisioningLocation.releasePort(null, p);
        }
    }

    public static boolean isSudoAllowed() {
        return SudoChecker.isSudoAllowed();
    }

    @Override
    public PersistenceObjectStore newPersistenceObjectStore(String container) {
        File basedir = new File(container);
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Destination directory must not be a file");
        }
        return new FileBasedObjectStore(basedir);
    }

    private static class SudoChecker {
        static volatile long lastSudoCheckTime = -1L;
        static boolean lastSudoResult = false;

        private SudoChecker() {
        }

        public static boolean isSudoAllowed() {
            if (Time.hasElapsedSince((long)lastSudoCheckTime, (Duration)Duration.FIVE_MINUTES)) {
                SudoChecker.checkIfNeeded();
            }
            return lastSudoResult;
        }

        private static synchronized void checkIfNeeded() {
            if (Time.hasElapsedSince((long)lastSudoCheckTime, (Duration)Duration.FIVE_MINUTES)) {
                try {
                    lastSudoResult = new ProcessTool().execCommands((Map<String, ?>)MutableMap.of(), Arrays.asList(BashCommands.sudo((String)"date"))) == 0;
                }
                catch (Exception e) {
                    lastSudoResult = false;
                    LOG.debug("Error checking sudo at localhost: " + e, (Throwable)e);
                }
                lastSudoCheckTime = System.currentTimeMillis();
            }
        }
    }

    public static class LocalhostMachine
    extends SshMachineLocation
    implements HasSubnetHostname {
        private static final Logger LOG = LoggerFactory.getLogger(LocalhostMachine.class);
        public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newConfigKeyWithDefault(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, true);
        private static final WithMutexes mutexSupport = new MutexSupport();
        private final Set<Integer> portsObtained = Sets.newLinkedHashSet();

        public LocalhostMachine() {
        }

        @Deprecated
        public LocalhostMachine(Map<?, ?> properties) {
            super((Map<?, ?>)MutableMap.builder().putAll(properties).build());
        }

        @Override
        public WithMutexes mutexes() {
            return mutexSupport;
        }

        @Override
        public boolean obtainSpecificPort(int portNumber) {
            if (!LocalhostMachineProvisioningLocation.isSudoAllowed() && portNumber <= 1024) {
                return false;
            }
            return LocalhostMachineProvisioningLocation.obtainSpecificPort(this.getAddress(), portNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int obtainPort(PortRange range) {
            int r = LocalhostMachineProvisioningLocation.obtainPort(this.getAddress(), range);
            Set<Integer> set = this.portsObtained;
            synchronized (set) {
                if (r > 0) {
                    this.portsObtained.add(r);
                }
            }
            LOG.debug("localhost.obtainPort(" + range + "), returning " + r);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releasePort(int portNumber) {
            Set<Integer> set = this.portsObtained;
            synchronized (set) {
                this.portsObtained.remove(portNumber);
            }
            LocalhostMachineProvisioningLocation.releasePort(this.getAddress(), portNumber);
        }

        @Override
        public OsDetails getOsDetails() {
            return BasicOsDetails.Factory.newLocalhostInstance();
        }

        @Override
        public LocalhostMachine configure(Map<?, ?> properties) {
            if (this.address == null && !properties.containsKey("address")) {
                this.address = LocalhostMachineProvisioningLocation.getLocalhostInetAddress();
            }
            super.configure((Map)properties);
            return this;
        }

        @Override
        public String getSubnetHostname() {
            return Networking.getReachableLocalHost().getHostName();
        }

        @Override
        public String getSubnetIp() {
            return Networking.getReachableLocalHost().getHostAddress();
        }
    }
}

