/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import javax.inject.Singleton;

@Singleton
public class JoinOnComma
implements Function<Object, String> {
    public String apply(Object o) {
        Preconditions.checkNotNull((Object)o, (Object)"input cannot be null");
        if (o.getClass().isArray()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < Array.getLength(o); ++i) {
                builder.add(Array.get(o, i));
            }
            o = builder.build();
        }
        Preconditions.checkArgument((boolean)(o instanceof Iterable), (Object)"you must pass an iterable or array");
        Iterable toJoin = (Iterable)o;
        Preconditions.checkArgument((!Iterables.isEmpty((Iterable)toJoin) ? 1 : 0) != 0, (Object)"you must pass an iterable or array with elements");
        return Joiner.on((char)',').join(toJoin);
    }
}

