/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.filters;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.AuthorizationApi;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.domain.Claims;
import org.jclouds.oauth.v2.domain.Token;
import org.jclouds.oauth.v2.filters.AutoValue_JWTBearerTokenFlow_TokenCacheKey;
import org.jclouds.oauth.v2.filters.OAuthFilter;

public class JWTBearerTokenFlow
implements OAuthFilter {
    private static final Joiner ON_COMMA = Joiner.on((String)",");
    private final Supplier<Credentials> credentialsSupplier;
    private final OAuthConfigFactory oauthConfigFactory;
    private final LoadingCache<TokenCacheKey, Token> tokenCache;

    @Inject
    JWTBearerTokenFlow(AuthorizeToken loader, @Named(value="jclouds.session-interval") long tokenDuration, @Provider Supplier<Credentials> credentialsSupplier, OAuthConfigFactory oauthConfigFactory) {
        this.credentialsSupplier = credentialsSupplier;
        this.oauthConfigFactory = oauthConfigFactory;
        long cacheExpirationSeconds = tokenDuration > 30L ? tokenDuration - 30L : tokenDuration;
        this.tokenCache = CacheBuilder.newBuilder().expireAfterWrite(cacheExpirationSeconds, TimeUnit.SECONDS).build((CacheLoader)loader);
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        long now = this.currentTimeSeconds();
        OAuthConfigFactory.OAuthConfig oauthConfig = this.oauthConfigFactory.forRequest(request);
        Claims claims = Claims.create(((Credentials)this.credentialsSupplier.get()).identity, ON_COMMA.join(oauthConfig.scopes()), oauthConfig.audience(), -1L, -1L);
        TokenCacheKey tokenCacheKey = TokenCacheKey.create(claims, now);
        Token token = (Token)this.tokenCache.getUnchecked((Object)tokenCacheKey);
        String authorization = String.format("%s %s", token.tokenType(), token.accessToken());
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", new String[]{authorization})).build();
    }

    long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    static abstract class TokenCacheKey {
        long startTime;

        public abstract Claims claims();

        public static TokenCacheKey create(Claims claims, long startTime) {
            AutoValue_JWTBearerTokenFlow_TokenCacheKey tokenCacheKey = new AutoValue_JWTBearerTokenFlow_TokenCacheKey(claims);
            tokenCacheKey.startTime = startTime;
            return tokenCacheKey;
        }

        TokenCacheKey() {
        }
    }

    static final class AuthorizeToken
    extends CacheLoader<TokenCacheKey, Token> {
        private final AuthorizationApi api;
        private final long tokenDuration;

        @Inject
        AuthorizeToken(AuthorizationApi api, @Named(value="jclouds.session-interval") long tokenDuration) {
            this.api = api;
            this.tokenDuration = tokenDuration;
        }

        public Token load(TokenCacheKey tokenCacheKey) throws Exception {
            Claims claims = Claims.create(tokenCacheKey.claims().iss(), tokenCacheKey.claims().scope(), tokenCacheKey.claims().aud(), tokenCacheKey.startTime + this.tokenDuration, tokenCacheKey.startTime);
            return this.api.authorize(claims);
        }
    }
}

