/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.internal.ConfigUtilsInternal;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdjunctType
implements Serializable {
    private static final long serialVersionUID = -662979234559595903L;
    private static final Logger LOG = LoggerFactory.getLogger(AdjunctType.class);
    private final String name;
    private final Map<String, ConfigKey<?>> configKeys;
    private final Set<ConfigKey<?>> configKeysSet;

    public AdjunctType(AbstractEntityAdjunct adjunct) {
        this(adjunct.getClass(), adjunct);
    }

    protected AdjunctType(Class<? extends EntityAdjunct> clazz) {
        this(clazz, null);
    }

    private AdjunctType(Class<? extends EntityAdjunct> clazz, AbstractEntityAdjunct adjunct) {
        this.name = clazz.getCanonicalName();
        this.configKeys = Collections.unmodifiableMap(AdjunctType.findConfigKeys(clazz, null));
        this.configKeysSet = ImmutableSet.copyOf(this.configKeys.values());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Policy {} config keys: {}", (Object)this.name, (Object)Joiner.on((String)", ").join(this.configKeys.keySet()));
        }
    }

    AdjunctType(String name, Map<String, ConfigKey<?>> configKeys) {
        this.name = name;
        this.configKeys = ImmutableMap.copyOf(configKeys);
        this.configKeysSet = ImmutableSet.copyOf(this.configKeys.values());
    }

    public String getName() {
        return this.name;
    }

    public Set<ConfigKey<?>> getConfigKeys() {
        return this.configKeysSet;
    }

    public ConfigKey<?> getConfigKey(String name) {
        return this.configKeys.get(name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.configKeys});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdjunctType o = (AdjunctType)obj;
        if (!Objects.equal((Object)this.name, (Object)o.getName())) {
            return false;
        }
        return Objects.equal(this.getConfigKeys(), o.getConfigKeys());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.name).add("configKeys", this.configKeys).toString();
    }

    protected static Map<String, ConfigKey<?>> findConfigKeys(Class<? extends EntityAdjunct> clazz, EntityAdjunct optionalInstance) {
        return ConfigUtilsInternal.findConfigKeys(clazz, optionalInstance);
    }
}

