/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.Map;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.resolve.jackson.AsPropertyIfAmbiguous;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonType;
import org.apache.brooklyn.core.typereg.AbstractTypePlanTransformer;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;

public class BeanWithTypePlanTransformer
extends AbstractTypePlanTransformer {
    public static final String FORMAT = "bean-with-type";
    public static final String TYPE_SIMPLE_KEY = "type";
    public static final String TYPE_UNAMBIGUOUS_KEY = AsPropertyIfAmbiguous.CONFLICTING_TYPE_NAME_PROPERTY_TRANSFORM.apply("type");

    public BeanWithTypePlanTransformer() {
        super(FORMAT, "Brooklyn YAML serialized with type", "Bean serialization format read/written as YAML or JSON as per Jackson with one trick that the 'type' field specifies the type or supertype");
    }

    @Override
    protected double scoreForNullFormat(Object o, RegisteredType registeredType, RegisteredTypeLoadingContext registeredTypeLoadingContext) {
        if (registeredType.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
            if (Strings.toString((Object)o).contains(TYPE_UNAMBIGUOUS_KEY + ":")) {
                return 0.8;
            }
            if (Strings.toString((Object)o).contains("type:")) {
                return 0.5;
            }
            if (Strings.toString((Object)o).contains(AsPropertyIfAmbiguous.CONFLICTING_TYPE_NAME_PROPERTY_TRANSFORM_ALT.apply(TYPE_SIMPLE_KEY))) {
                return 0.4;
            }
        }
        return 0.0;
    }

    @Override
    protected double scoreForNonmatchingNonnullFormat(String s, Object o, RegisteredType registeredType, RegisteredTypeLoadingContext registeredTypeLoadingContext) {
        return 0.0;
    }

    @Override
    public double scoreForType(RegisteredType type, RegisteredTypeLoadingContext context) {
        if (BrooklynTypeRegistry.RegisteredTypeKind.SPEC.equals((Object)type.getKind())) {
            return 0.0;
        }
        return super.scoreForType(type, context);
    }

    @Override
    protected AbstractBrooklynObjectSpec<?, ?> createSpec(RegisteredType registeredType, RegisteredTypeLoadingContext registeredTypeLoadingContext) throws Exception {
        throw new UnsupportedTypePlanException("spec not supported by this bean transformer");
    }

    @Override
    protected Object createBean(RegisteredType registeredType, RegisteredTypeLoadingContext registeredTypeLoadingContext) throws Exception {
        TypeToken<?> expectedType;
        Map definition;
        try {
            Iterable parsed = Yamls.parseAll((String)((String)registeredType.getPlan().getPlanData()));
            Iterator pi = parsed.iterator();
            if (!pi.hasNext()) {
                throw new IllegalStateException("No data");
            }
            definition = (Map)pi.next();
            if (pi.hasNext()) {
                throw new IllegalStateException("YAML contained multiple items");
            }
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)("Invalid YAML in definition of '" + registeredType.getId() + "'"), (Throwable)e);
        }
        BrooklynClassLoadingContext loader = registeredTypeLoadingContext != null ? registeredTypeLoadingContext.getLoader() : null;
        loader = CatalogUtils.newClassLoadingContext(this.mgmt, registeredType, loader);
        String definitionMapSerializedAsString = BeanWithTypeUtils.newSimpleMapper().writeValueAsString((Object)definition);
        ObjectMapper mapper = BeanWithTypeUtils.newMapper(this.mgmt, true, loader, true);
        Object result = mapper.readValue(definitionMapSerializedAsString, Object.class);
        Object typeS = definition.get(TYPE_SIMPLE_KEY);
        if (typeS instanceof String && !(expectedType = new BrooklynTypeNameResolution.BrooklynTypeNameResolver("creating-bean-" + registeredType, this.mgmt, loader, true, true).getTypeToken((String)typeS)).getRawType().isInstance(result)) {
            definition.remove(TYPE_SIMPLE_KEY);
            definitionMapSerializedAsString = BeanWithTypeUtils.newSimpleMapper().writeValueAsString((Object)definition);
            result = mapper.readValue(definitionMapSerializedAsString, BrooklynJacksonType.asJavaType(mapper, expectedType));
        }
        return result;
    }
}

