/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.external;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.external.SshWorkflowStep;
import org.apache.brooklyn.core.workflow.steps.variables.SetVariableWorkflowStep;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.internal.SystemProcessTaskFactory;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.text.Strings;

public class ShellWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "${command...}";
    public static final ConfigKey<String> COMMAND = ConfigKeys.newStringConfigKey("command");
    public static final ConfigKey<Map<String, Object>> ENV = new MapConfigKey.Builder<Object>(Object.class, "env").build();
    public static final ConfigKey<DslPredicates.DslPredicate<Integer>> EXIT_CODE = ConfigKeys.newConfigKey(new TypeToken<DslPredicates.DslPredicate<Integer>>(){}, "exit_code");
    public static final ConfigKey<Integer> OUTPUT_MAX_SIZE = ConfigKeys.newIntegerConfigKey("output_max_size", "Maximum size for stdout and stderr, or -1 for no limit", 100000);
    ConfigKey<SetVariableWorkflowStep.InterpolationMode> INTERPOLATION_MODE = ConfigKeys.newConfigKeyWithDefault(SetVariableWorkflowStep.INTERPOLATION_MODE, SetVariableWorkflowStep.InterpolationMode.FULL);
    ConfigKey<TemplateProcessor.InterpolationErrorMode> INTERPOLATION_ERRORS = ConfigKeys.newConfigKeyWithDefault(SetVariableWorkflowStep.INTERPOLATION_ERRORS, TemplateProcessor.InterpolationErrorMode.IGNORE);

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        if (Boolean.TRUE.equals(context.getManagementContext().getConfig().getConfig(BrooklynServerConfig.SHELL_WORKFLOW_STEP_DISABLED))) {
            throw new IllegalStateException("The 'shell' workflow step is disabled in this intance of Cloudsoft AMP.");
        }
        Entitlements.checkEntitled(context.getManagementContext().getEntitlementManager(), Entitlements.EXECUTE_SCRIPT, null);
        String command = (String)new SetVariableWorkflowStep.ConfigurableInterpolationEvaluation(context, TypeToken.of(String.class), this.getInput().get(COMMAND.getName()), context.getInputOrDefault(this.INTERPOLATION_MODE), context.getInputOrDefault(this.INTERPOLATION_ERRORS)).evaluate();
        if (Strings.isBlank((CharSequence)command)) {
            throw new IllegalStateException("'command' is required");
        }
        return DynamicTasks.queue(SshWorkflowStep.customizeProcessTaskFactory(context, new SystemProcessTaskFactory(command)).newTask()).asTask().getUnchecked();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return false;
    }
}

