/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group.zoneaware;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancingNodePlacementStrategy
implements DynamicCluster.NodePlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BalancingNodePlacementStrategy.class);

    @Override
    public List<Location> locationsForAdditions(Multimap<Location, Entity> currentMembers, Collection<? extends Location> locs, int numToAdd) {
        if (locs.isEmpty() && numToAdd > 0) {
            throw new IllegalArgumentException("No locations supplied, when requesting locations for " + numToAdd + " nodes");
        }
        ArrayList result = Lists.newArrayList();
        Map<Location, Integer> locSizes = this.toMutableLocationSizes(currentMembers, locs);
        for (int i = 0; i < numToAdd; ++i) {
            Location leastPopulatedLoc = null;
            int leastPopulatedLocSize = 0;
            for (Location location : locs) {
                int locSize = locSizes.get(location);
                if (leastPopulatedLoc != null && locSize >= leastPopulatedLocSize) continue;
                leastPopulatedLoc = location;
                leastPopulatedLocSize = locSize;
            }
            assert (leastPopulatedLoc != null) : "leastPopulatedLoc=null; locs=" + locs + "; currentMembers=" + currentMembers;
            result.add(leastPopulatedLoc);
            locSizes.put(leastPopulatedLoc, locSizes.get(leastPopulatedLoc) + 1);
        }
        return result;
    }

    @Override
    public List<Entity> entitiesToRemove(Multimap<Location, Entity> currentMembers, int numToRemove) {
        if (currentMembers.isEmpty()) {
            throw new IllegalArgumentException("No members supplied, when requesting removal of " + numToRemove + " nodes");
        }
        if (currentMembers.size() < numToRemove) {
            LOG.warn("Request to remove " + numToRemove + " when only " + currentMembers.size() + " members (continuing): " + currentMembers);
            numToRemove = currentMembers.size();
        }
        LinkedHashMap numToRemovePerLoc = Maps.newLinkedHashMap();
        Map<Location, Integer> locSizes = this.toMutableLocationSizes(currentMembers, (Iterable<? extends Location>)ImmutableList.of());
        for (int i = 0; i < numToRemove; ++i) {
            Location mostPopulatedLoc = null;
            int mostPopulatedLocSize = 0;
            for (Location loc : locSizes.keySet()) {
                int locSize = locSizes.get(loc);
                if (locSize <= 0 || mostPopulatedLoc != null && locSize <= mostPopulatedLocSize) continue;
                mostPopulatedLoc = loc;
                mostPopulatedLocSize = locSize;
            }
            assert (mostPopulatedLoc != null) : "leastPopulatedLoc=null; currentMembers=" + currentMembers;
            numToRemovePerLoc.put(mostPopulatedLoc, (numToRemovePerLoc.get(mostPopulatedLoc) == null ? 0 : (Integer)numToRemovePerLoc.get(mostPopulatedLoc)) + 1);
            locSizes.put(mostPopulatedLoc, locSizes.get(mostPopulatedLoc) - 1);
        }
        ArrayList result = Lists.newArrayList();
        for (Map.Entry entry : numToRemovePerLoc.entrySet()) {
            result.addAll(this.pickNewest(currentMembers.get(entry.getKey()), (Integer)entry.getValue()));
        }
        return result;
    }

    protected Map<Location, Integer> toMutableLocationSizes(Multimap<Location, Entity> currentMembers, Iterable<? extends Location> otherLocs) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Location location : currentMembers.keySet()) {
            result.put(location, currentMembers.get((Object)location).size());
        }
        for (Location location : otherLocs) {
            if (result.containsKey(location)) continue;
            result.put(location, 0);
        }
        return result;
    }

    protected Collection<Entity> pickNewest(Collection<Entity> contenders, Integer numToPick) {
        LinkedList stoppables = Lists.newLinkedList((Iterable)Iterables.filter(contenders, (Predicate)Predicates.instanceOf(Startable.class)));
        Collections.sort(stoppables, new Comparator<Entity>(){

            @Override
            public int compare(Entity a, Entity b) {
                return (int)(b.getCreationTime() - a.getCreationTime());
            }
        });
        return stoppables.subList(0, Math.min(numToPick, stoppables.size()));
    }

    public String toString() {
        return this.getClass().getName();
    }
}

