/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.reflect.TypeToken;
import java.util.Collection;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.entity.stock.BasicStartable;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectorStartableImpl
extends AbstractEntity
implements BasicStartable {
    private static final Logger log = LoggerFactory.getLogger(EffectorStartableImpl.class);

    @Override
    @Effector(description="Start the process/service represented by an entity")
    public void start(@EffectorParam(name="locations") Collection<? extends Location> locations) {
        log.info("Invoking start (method) on " + this);
        this.invoke(START, ConfigBag.newInstance().configure(StartParameters.LOCATIONS, locations).getAllConfig()).getUnchecked();
    }

    @Override
    @Effector(description="Stop the process/service represented by an entity")
    public void stop() {
        log.info("Invoking stop (method) on " + this);
        this.invoke(STOP).getUnchecked();
    }

    @Override
    @Effector(description="Restart the process/service represented by an entity")
    public void restart() {
        log.info("Invoking restart (method) on " + this);
        this.invoke(RESTART).getUnchecked();
    }

    public static class StartParameters {
        public static final ConfigKey<Collection<? extends Location>> LOCATIONS = ConfigKeys.newConfigKey(new TypeToken<Collection<? extends Location>>(){}, "locations", "locations where the entity should be started");
    }
}

