/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.internal.PaginatedCollection;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.functions.BaseToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Path(value="/images")
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface ImageApi
extends Closeable {
    @Named(value="image:list")
    @GET
    @ResponseParser(value=ParseImages.class)
    @Transform(value=ParseImages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Image> list();

    @Named(value="image:list")
    @GET
    @ResponseParser(value=ParseImages.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Image> list(ImageListOptions var1);

    @Named(value="image:get")
    @GET
    @SelectJson(value={"image"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@PathParam(value="id") int var1);

    @Named(value="image:get")
    @GET
    @SelectJson(value={"image"})
    @Path(value="/{slug}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@PathParam(value="slug") String var1);

    @Named(value="image:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="id") int var1);

    public static final class ParseImages
    extends ParseJson<Images> {
        @Inject
        ParseImages(Json json) {
            super(json, TypeLiteral.get(Images.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Image, ImageListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ImageListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Image> fetchPageUsingOptions(ImageListOptions options, Optional<Object> arg0) {
                return this.api.imageApi().list(options);
            }
        }

        private static class Images
        extends PaginatedCollection<Image> {
            @ConstructorProperties(value={"images", "meta", "links"})
            public Images(List<Image> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }
}

