/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.steps.CustomWorkflowStep;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.WorkflowSoftwareProcess;
import org.apache.brooklyn.entity.software.base.WorkflowSoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowSoftwareProcessSshDriver
extends AbstractSoftwareProcessSshDriver
implements WorkflowSoftwareProcessDriver {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowSoftwareProcessSshDriver.class);

    public WorkflowSoftwareProcessSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    protected String getInstallLabelExtraSalt() {
        Integer hash = this.hashCodeIfResolved(WorkflowSoftwareProcess.INSTALL_WORKFLOW);
        if (hash == null) {
            return Identifiers.makeRandomId((int)8);
        }
        if (hash == 0) {
            return "default";
        }
        return Identifiers.makeIdFromHash((long)hash.intValue());
    }

    private Integer hashCodeIfResolved(ConfigKey<?> ... keys) {
        int hash = 0;
        for (ConfigKey<?> k : keys) {
            Maybe value = ((BrooklynObjectInternal.ConfigurationSupportInternal)this.getEntity().config()).getNonBlocking(k);
            if (!value.isPresent()) continue;
            hash = hash * 31 + (value.get() == null ? 0 : value.get().hashCode());
        }
        return hash;
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        return MutableMap.copyOf(super.getShellEnvironment()).add((Object)"PID_FILE", (Object)this.getPidFile());
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid.txt"});
    }

    protected Maybe<Object> runWorkflow(ConfigKey<CustomWorkflowStep> key) {
        CustomWorkflowStep workflow = (CustomWorkflowStep)this.entity.getConfig(key);
        if (workflow == null) {
            return Maybe.absent();
        }
        WorkflowExecutionContext workflowContext = workflow.newWorkflowExecution((Entity)this.entity, key.getName().toLowerCase(), null);
        return Maybe.of((Object)DynamicTasks.queueIfPossible((TaskAdaptable)((TaskAdaptable)workflowContext.getTask(true).get())).orSubmitAsync((Entity)this.entity).getTask().getUnchecked());
    }

    @Override
    public void install() {
        this.runWorkflow(WorkflowSoftwareProcess.INSTALL_WORKFLOW);
    }

    @Override
    public void customize() {
        this.runWorkflow(WorkflowSoftwareProcess.CUSTOMIZE_WORKFLOW);
    }

    @Override
    public void launch() {
        this.runWorkflow(WorkflowSoftwareProcess.LAUNCH_WORKFLOW);
    }

    @Override
    public boolean isRunning() {
        try {
            Maybe<Object> wr = this.runWorkflow(WorkflowSoftwareProcess.CHECK_RUNNING_WORKFLOW);
            if (wr.isAbsent()) {
                if (Boolean.TRUE.equals(this.entity.config().get(WorkflowSoftwareProcess.USE_PID_FILE))) {
                    ScriptHelper script = this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running");
                    return script.execute() == 0;
                }
                LOG.warn("No workflow to check if " + this.entity + " is running; will assume it is. But it is highly recommended to validate that the software is running.");
                return true;
            }
            Maybe success = TypeCoercions.tryCoerce((Object)wr.get(), Boolean.class);
            if (success.isPresentAndNonNull()) {
                return (Boolean)success.get();
            }
            LOG.debug("No workflow to check if " + this.entity + " is running returned " + wr.get() + "; treating this as true, but it is recommended to return true or false explicitly");
            return true;
        }
        catch (Throwable t) {
            Exceptions.propagateIfFatal((Throwable)t);
            LOG.warn("Workflow for check-running at " + this.entity + " failed, assuming software not running: " + t);
            LOG.debug("Workflow error trace for: " + t, t);
            return false;
        }
    }

    @Override
    public void stop() {
        this.runWorkflow(WorkflowSoftwareProcess.STOP_WORKFLOW);
    }
}

