/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.tasks.kubectl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.ha.BrooklynBomOsgiArchiveInstaller;
import org.apache.brooklyn.tasks.kubectl.ContainerCommons;
import org.apache.brooklyn.tasks.kubectl.ContainerTaskResult;
import org.apache.brooklyn.tasks.kubectl.KubeJobFileCreator;
import org.apache.brooklyn.tasks.kubectl.PullPolicy;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.task.system.SimpleProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.internal.SystemProcessTaskFactory;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringShortener;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTaskFactory<T extends ContainerTaskFactory<T, RET>, RET>
implements SimpleProcessTaskFactory<T, ContainerTaskResult, RET, Task<RET>> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerTaskFactory.class);
    protected String summary;
    protected String jobIdentifier = "";
    protected final ConfigBag config = ConfigBag.newInstance();
    private String namespace;
    private boolean namespaceRandom = false;
    private Boolean createNamespace;
    private Boolean deleteNamespace;
    Function<ContainerTaskResult, RET> returnConversion;

    private <T extends TaskAdaptable<?>> T runTask(Entity entity, T t, boolean block, boolean markTransient) {
        if (markTransient) {
            BrooklynTaskTags.setTransient((Task)t.asTask());
        }
        Entities.submit((Entity)entity, t);
        if (block) {
            t.asTask().blockUntilEnded(Duration.PRACTICALLY_FOREVER);
        }
        return t;
    }

    public Task<RET> newTask() {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        TaskBuilder taskBuilder = Tasks.builder().dynamic(true).displayName(this.summary).tag((Object)BrooklynTaskTags.tagForStream((String)"stdout", (ByteArrayOutputStream)stdout)).tag((Object)new ContainerTaskResult()).body(() -> {
            List commandsCfg = (List)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.COMMAND);
            List argumentsCfg = (List)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.ARGUMENTS);
            Object bashScript = EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.BASH_SCRIPT);
            if (bashScript != null) {
                if (!commandsCfg.isEmpty()) {
                    LOG.warn("Ignoring 'command' " + commandsCfg + " because bashScript is set");
                }
                if (!argumentsCfg.isEmpty()) {
                    LOG.warn("Ignoring 'args' " + argumentsCfg + " because bashScript is set");
                }
                commandsCfg = MutableList.of((Object)"/bin/bash", (Object)"-c");
                MutableList argumentsCfgO = bashScript instanceof Iterable ? MutableList.copyOf((Iterable)((Iterable)bashScript)) : MutableList.of((Object)bashScript);
                argumentsCfg = MutableList.of((Object)argumentsCfgO.stream().map(x -> "" + x).collect(Collectors.joining("\n")));
            }
            PullPolicy containerImagePullPolicy = (PullPolicy)((Object)((Object)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.CONTAINER_IMAGE_PULL_POLICY)));
            String workingDir = (String)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.WORKING_DIR);
            Set volumeMounts = (Set)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.VOLUME_MOUNTS);
            Set volumes = (Set)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.VOLUMES);
            String kubeJobName = this.initNamespaceAndGetNewJobName();
            String containerImage = (String)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.CONTAINER_IMAGE);
            Entity entity = BrooklynTaskTags.getContextEntity((Task)Tasks.current());
            LOG.debug("Submitting container job in namespace " + this.namespace + ", name " + kubeJobName);
            Map env = new ShellEnvironmentSerializer(((EntityInternal)entity).getManagementContext()).serialize((Map)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.SHELL_ENVIRONMENT));
            KubeJobFileCreator kubeJobFileCreator = new KubeJobFileCreator().withImage(containerImage).withImagePullPolicy(containerImagePullPolicy).withName(kubeJobName).withCommand(Lists.newArrayList((Iterable)commandsCfg)).withArgs(argumentsCfg).withEnv(env).withVolumeMounts(volumeMounts).withVolumes(volumes).withWorkingDir(workingDir);
            BrooklynBomOsgiArchiveInstaller.FileWithTempInfo<File> jobYaml = kubeJobFileCreator.createFile();
            Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForEnvStream((String)"env", (Map)env));
            Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStream((String)"kube job config", (ByteArrayOutputStream)Streams.byteArrayOfString((String)kubeJobFileCreator.getAsString())));
            try {
                ContainerTaskResult containerTaskResult;
                block35: {
                    block34: {
                        Duration timeout = (Duration)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.TIMEOUT);
                        ContainerTaskResult result = (ContainerTaskResult)TaskTags.getTagsFast((Task)Tasks.current()).stream().filter(x -> x instanceof ContainerTaskResult).findAny().orElseGet(() -> {
                            LOG.warn("Result object not set on tag at " + Tasks.current() + "; creating");
                            ContainerTaskResult x = new ContainerTaskResult();
                            TaskTags.addTagDynamically((TaskAdaptable)Tasks.current(), (Object)x);
                            return x;
                        });
                        result.namespace = this.namespace;
                        result.kubeJobName = kubeJobName;
                        if (!this.namespace.matches("[A-Za-z0-9_.-]+")) {
                            throw new IllegalStateException("Invalid namespace: " + this.namespace);
                        }
                        if (!kubeJobName.matches("[A-Za-z0-9_.-]+")) {
                            throw new IllegalStateException("Invalid job name: " + kubeJobName);
                        }
                        ProcessTaskWrapper createNsJob = null;
                        if (!Boolean.FALSE.equals(this.createNamespace)) {
                            ProcessTaskFactory createNsJobF = this.newSimpleTaskFactory(String.format("kubectl create namespace %s", this.namespace)).summary("Set up namespace").returning(x -> x);
                            if (this.createNamespace == null) {
                                createNsJobF.allowingNonZeroExitCode();
                            }
                            createNsJob = (ProcessTaskWrapper)this.runTask(entity, createNsJobF.newTask(), true, true);
                        }
                        boolean deleteNamespaceHere = Boolean.TRUE.equals(this.deleteNamespace);
                        try {
                            String newStdout;
                            if (createNsJob != null) {
                                ProcessTaskWrapper nsDetails = (ProcessTaskWrapper)createNsJob.get();
                                if (nsDetails.getExitCode() == 0) {
                                    LOG.debug("Namespace created");
                                    if (this.deleteNamespace == null) {
                                        deleteNamespaceHere = true;
                                    }
                                } else if (nsDetails.getExitCode() == 1 && nsDetails.getStderr().contains("AlreadyExists")) {
                                    if (Boolean.TRUE.equals(this.createNamespace)) {
                                        LOG.warn("Namespace " + this.namespace + " already exists; failing");
                                        throw new IllegalStateException("Namespace " + this.namespace + " exists when creating a job that expects to create this namespace");
                                    }
                                    LOG.debug("Namespace exists already; reusing it");
                                } else {
                                    LOG.warn("Unexpected namespace creation problem: " + nsDetails.getStderr() + "(code " + nsDetails.getExitCode() + ")");
                                    if (this.deleteNamespace == null) {
                                        deleteNamespaceHere = true;
                                    }
                                    throw new IllegalStateException("Unexpected namespace creation problem (" + this.namespace + "); see log for more details");
                                }
                            }
                            this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl apply -f %s --namespace=%s", jobYaml.getFile().getAbsolutePath(), this.namespace)).summary("Submit job").newTask(), true, true);
                            CountdownTimer timer = CountdownTimer.newInstanceStarted((Duration)timeout);
                            ContainerCommons.PodPhases phaseOnceActive = this.waitForContainerAvailable(entity, kubeJobName, result, timer);
                            result.containerStarted = true;
                            ContainerTaskResult containerTaskResult2 = result;
                            synchronized (containerTaskResult2) {
                                result.notifyAll();
                            }
                            boolean succeeded = ContainerCommons.PodPhases.Succeeded == phaseOnceActive || ContainerCommons.PodPhases.Failed != phaseOnceActive && this.waitForContainerCompletedUsingPodState(stdout, kubeJobName, entity, timer) != false;
                            LOG.debug("Container job " + kubeJobName + " completed, success " + succeeded);
                            ProcessTaskWrapper retrieveOutput = (ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl logs jobs/%s --namespace=%s", kubeJobName, this.namespace)).summary("Retrieve output").newTask(), false, true);
                            ProcessTaskWrapper retrieveExitCode = (ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].status.containerStatuses[0].state.terminated.exitCode}'", this.namespace, kubeJobName)).summary("Retrieve exit code").newTask(), false, true);
                            result.mainStdout = newStdout = (String)retrieveOutput.get();
                            this.updateStdoutWithNewData(stdout, newStdout);
                            retrieveExitCode.get();
                            String exitCodeS = retrieveExitCode.getStdout();
                            result.mainExitCode = Strings.isNonBlank((CharSequence)exitCodeS) ? Integer.valueOf(Integer.parseInt(exitCodeS.trim())) : Integer.valueOf(-1);
                            result.containerEnded = true;
                            containerTaskResult = result;
                            synchronized (containerTaskResult) {
                                result.notifyAll();
                            }
                            if (result.mainExitCode != 0 && ((Boolean)this.config.get(ContainerCommons.REQUIRE_EXIT_CODE_ZERO)).booleanValue()) {
                                LOG.info("Failed container job " + this.namespace + " (exit code " + result.mainExitCode + ") output: " + result.mainStdout);
                                throw new IllegalStateException("Non-zero exit code (" + result.mainExitCode + ") disallowed");
                            }
                            ContainerTaskResult containerTaskResult3 = containerTaskResult = this.returnConversion == null ? result : this.returnConversion.apply(result);
                            if (!deleteNamespaceHere) break block34;
                            this.doDeleteNamespace(!this.namespaceRandom, true);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (deleteNamespaceHere) {
                                    this.doDeleteNamespace(!this.namespaceRandom, true);
                                } else {
                                    Boolean devMode = (Boolean)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.KEEP_CONTAINER_FOR_DEBUGGING);
                                    if (!Boolean.TRUE.equals(devMode)) {
                                        Task task = (Task)Entities.submit((Entity)entity, (TaskAdaptable)BrooklynTaskTags.setTransient((Task)((ProcessTaskWrapper)this.newDeleteJobTask(kubeJobName).allowingNonZeroExitCode().newTask()).asTask()));
                                    }
                                }
                                DynamicTasks.waitForLast();
                                throw throwable;
                            }
                            catch (Exception e) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                        }
                        break block35;
                    }
                    Boolean devMode = (Boolean)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.KEEP_CONTAINER_FOR_DEBUGGING);
                    if (!Boolean.TRUE.equals(devMode)) {
                        Task task = (Task)Entities.submit((Entity)entity, (TaskAdaptable)BrooklynTaskTags.setTransient((Task)((ProcessTaskWrapper)this.newDeleteJobTask(kubeJobName).allowingNonZeroExitCode().newTask()).asTask()));
                    }
                }
                DynamicTasks.waitForLast();
                return containerTaskResult;
            }
            finally {
                jobYaml.deleteIfTemp();
            }
        });
        return taskBuilder.build();
    }

    private Boolean waitForContainerCompletedUsingK8sWaitFor(ByteArrayOutputStream stdout, String kubeJobName, Entity entity, CountdownTimer timer) {
        return (Boolean)this.runTask(entity, Tasks.builder().dynamic(true).displayName("Wait for success or failure").body(() -> {
            while (true) {
                LOG.debug("Container job " + kubeJobName + " submitted, now waiting on success or failure");
                long secondsLeft = Math.min(Math.max(1L, timer.getDurationRemaining().toSeconds()), 5L);
                Boolean x = this.checkForContainerCompletedUsingK8sWaitFor(kubeJobName, entity, secondsLeft);
                if (x != null) {
                    return x;
                }
                LOG.debug("Container job " + this.namespace + " not yet complete, will retry");
                this.refreshStdout(entity, stdout, kubeJobName, timer);
                Time.sleep((Duration)Duration.millis((Number)50));
            }
        }).build(), false, true).getUnchecked();
    }

    private Boolean waitForContainerCompletedUsingPodState(ByteArrayOutputStream stdout, String kubeJobName, Entity entity, CountdownTimer timer) {
        return (Boolean)this.runTask(entity, Tasks.builder().dynamic(true).displayName("Wait for success or failure").body(() -> {
            long retryDelay = 10L;
            while (true) {
                LOG.debug("Container job " + kubeJobName + " submitted, now waiting on success or failure");
                ContainerCommons.PodPhases phase = this.checkPodPhase(entity, kubeJobName);
                if (phase.equals((Object)ContainerCommons.PodPhases.Succeeded)) {
                    return true;
                }
                if (phase.equals((Object)ContainerCommons.PodPhases.Failed)) {
                    return false;
                }
                LOG.debug("Container job " + this.namespace + " not yet complete, will sleep then retry");
                this.refreshStdout(entity, stdout, kubeJobName, timer);
                Time.sleep((Duration)Duration.millis((Number)retryDelay));
                if ((retryDelay = (long)((double)retryDelay * 1.5)) <= 250L) continue;
                retryDelay = 500L;
            }
        }).build(), false, true).getUnchecked();
    }

    private void refreshStdout(Entity entity, ByteArrayOutputStream stdout, String kubeJobName, CountdownTimer timer) throws IOException {
        ProcessTaskWrapper outputSoFarCmd = (ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl logs jobs/%s --namespace=%s", kubeJobName, this.namespace)).summary("Retrieve output so far").allowingNonZeroExitCode().newTask(), true, true);
        if (outputSoFarCmd.getExitCode() != 0) {
            throw new IllegalStateException("Error detected with container job while reading logs (exit code " + outputSoFarCmd.getExitCode() + "): " + outputSoFarCmd.getStdout() + " / " + outputSoFarCmd.getStderr());
        }
        this.updateStdoutWithNewData(stdout, (String)outputSoFarCmd.get());
        if (timer.isExpired()) {
            throw new IllegalStateException("Timeout waiting for success or failure");
        }
    }

    private void updateStdoutWithNewData(ByteArrayOutputStream receiverStream, String outputFound) throws IOException {
        int bytesAlreadyRead = receiverStream.size();
        if (bytesAlreadyRead <= outputFound.length()) {
            String newOutput = outputFound.substring(receiverStream.size());
            LOG.debug("Container job " + this.namespace + " output: " + newOutput);
            receiverStream.write(newOutput.getBytes(StandardCharsets.UTF_8));
        } else {
            LOG.debug("Container job " + this.namespace + " output reset, length " + outputFound.length() + " less than " + bytesAlreadyRead + "; ignoring new output:\n" + outputFound + "\n" + new String(receiverStream.toByteArray()));
            receiverStream.reset();
            receiverStream.write(outputFound.getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean checkForContainerCompletedUsingK8sWaitFor(String kubeJobName, Entity entity, long timeoutSeconds) {
        AtomicInteger finishCount = new AtomicInteger(0);
        ProcessTaskWrapper waitForSuccess = (ProcessTaskWrapper)Entities.submit((Entity)entity, (TaskAdaptable)this.newSimpleTaskFactory(String.format("kubectl wait --timeout=%ds --for=condition=complete job/%s --namespace=%s", timeoutSeconds, kubeJobName, this.namespace)).summary("Wait for success ('complete')").allowingNonZeroExitCode().newTask());
        Entities.submit((Entity)entity, (TaskAdaptable)Tasks.create((String)"Wait for success then notify", () -> {
            try {
                if (((String)waitForSuccess.get()).contains("condition met")) {
                    LOG.debug("Container job " + kubeJobName + " detected as completed (succeeded) in kubernetes");
                }
            }
            finally {
                AtomicInteger atomicInteger = finishCount;
                synchronized (atomicInteger) {
                    finishCount.incrementAndGet();
                    finishCount.notifyAll();
                }
            }
        }));
        ProcessTaskWrapper waitForFailed = (ProcessTaskWrapper)Entities.submit((Entity)entity, (TaskAdaptable)this.newSimpleTaskFactory(String.format("kubectl wait --timeout=%ds --for=condition=failed job/%s --namespace=%s", timeoutSeconds, kubeJobName, this.namespace)).summary("Wait for failed").allowingNonZeroExitCode().newTask());
        Entities.submit((Entity)entity, (TaskAdaptable)Tasks.create((String)"Wait for failed then notify", () -> {
            try {
                if (((String)waitForFailed.get()).contains("condition met")) {
                    LOG.debug("Container job " + kubeJobName + " detected as failed in kubernetes (may be valid non-zero exit)");
                }
            }
            finally {
                AtomicInteger atomicInteger = finishCount;
                synchronized (atomicInteger) {
                    finishCount.incrementAndGet();
                    finishCount.notifyAll();
                }
            }
        }));
        while (finishCount.get() == 0) {
            LOG.debug("Container job " + kubeJobName + " waiting on complete or failed");
            try {
                AtomicInteger atomicInteger = finishCount;
                synchronized (atomicInteger) {
                    finishCount.wait(Duration.TEN_SECONDS.toMilliseconds());
                }
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        if (waitForSuccess.isDone() && waitForSuccess.getExitCode() == 0) {
            return true;
        }
        if (waitForFailed.isDone() && waitForFailed.getExitCode() == 0) {
            return false;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean checkForContainerCompletedUsingPodState(String kubeJobName, Entity entity, long timeoutSeconds) {
        AtomicInteger finishCount = new AtomicInteger(0);
        ProcessTaskWrapper waitForSuccess = (ProcessTaskWrapper)Entities.submit((Entity)entity, (TaskAdaptable)this.newSimpleTaskFactory(String.format("kubectl wait --timeout=%ds --for=condition=complete job/%s --namespace=%s", timeoutSeconds, kubeJobName, this.namespace)).summary("Wait for success ('complete')").allowingNonZeroExitCode().newTask());
        Entities.submit((Entity)entity, (TaskAdaptable)Tasks.create((String)"Wait for success then notify", () -> {
            try {
                if (((String)waitForSuccess.get()).contains("condition met")) {
                    LOG.debug("Container job " + kubeJobName + " detected as completed (succeeded) in kubernetes");
                }
            }
            finally {
                AtomicInteger atomicInteger = finishCount;
                synchronized (atomicInteger) {
                    finishCount.incrementAndGet();
                    finishCount.notifyAll();
                }
            }
        }));
        ProcessTaskWrapper waitForFailed = (ProcessTaskWrapper)Entities.submit((Entity)entity, (TaskAdaptable)this.newSimpleTaskFactory(String.format("kubectl wait --timeout=%ds --for=condition=failed job/%s --namespace=%s", timeoutSeconds, kubeJobName, this.namespace)).summary("Wait for failed").allowingNonZeroExitCode().newTask());
        Entities.submit((Entity)entity, (TaskAdaptable)Tasks.create((String)"Wait for failed then notify", () -> {
            try {
                if (((String)waitForFailed.get()).contains("condition met")) {
                    LOG.debug("Container job " + kubeJobName + " detected as failed in kubernetes (may be valid non-zero exit)");
                }
            }
            finally {
                AtomicInteger atomicInteger = finishCount;
                synchronized (atomicInteger) {
                    finishCount.incrementAndGet();
                    finishCount.notifyAll();
                }
            }
        }));
        while (finishCount.get() == 0) {
            LOG.debug("Container job " + kubeJobName + " waiting on complete or failed");
            try {
                AtomicInteger atomicInteger = finishCount;
                synchronized (atomicInteger) {
                    finishCount.wait(Duration.TEN_SECONDS.toMilliseconds());
                }
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        if (waitForSuccess.isDone() && waitForSuccess.getExitCode() == 0) {
            return true;
        }
        if (waitForFailed.isDone() && waitForFailed.getExitCode() == 0) {
            return false;
        }
        return null;
    }

    private ContainerCommons.PodPhases waitForContainerAvailable(Entity entity, String kubeJobName, ContainerTaskResult result, CountdownTimer timer) {
        return (ContainerCommons.PodPhases)((Object)this.runTask(entity, Tasks.builder().dynamic(true).displayName("Wait for container to be running (or fail)").body(() -> {
            long first;
            long last = first = System.currentTimeMillis();
            long backoffMillis = 10L;
            ContainerCommons.PodPhases phase = ContainerCommons.PodPhases.Unknown;
            long startupReportDelay = 1000L;
            while (timer.isNotExpired()) {
                String failedEvents;
                phase = this.checkPodPhase(entity, kubeJobName);
                if (phase != ContainerCommons.PodPhases.Unknown && Strings.isBlank((CharSequence)result.kubePodName)) {
                    result.kubePodName = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].metadata.name}'", this.namespace, kubeJobName)).summary("Get pod name").allowingNonZeroExitCode().newTask(), false, true)).get()).trim();
                }
                if (phase == ContainerCommons.PodPhases.Failed || phase == ContainerCommons.PodPhases.Succeeded || phase == ContainerCommons.PodPhases.Running) {
                    if (startupReportDelay > 5000L) {
                        LOG.info("Container detected in state " + (Object)((Object)phase) + " after " + Duration.millis((Number)(System.currentTimeMillis() - first)));
                    } else {
                        LOG.debug("Container detected in state " + (Object)((Object)phase) + " after " + Duration.millis((Number)(System.currentTimeMillis() - first)));
                    }
                    return phase;
                }
                if (phase == ContainerCommons.PodPhases.Pending && Strings.isNonBlank((CharSequence)result.kubePodName) && !"[]".equals(failedEvents = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl --namespace %s get events --field-selector=reason=Failed,involvedObject.name=%s -ojsonpath='{.items}'", this.namespace, result.kubePodName)).summary("Check pod failed events").allowingNonZeroExitCode().newTask(), false, true)).get()).trim())) {
                    String events = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl --namespace %s get events --field-selector=involvedObject.name=%s", this.namespace, result.kubePodName)).summary("Get pod events on failure").allowingNonZeroExitCode().newTask(), false, false)).get()).trim();
                    throw new IllegalStateException("Job pod failed: " + failedEvents + "\n" + events);
                }
                if (System.currentTimeMillis() - last > startupReportDelay) {
                    String events;
                    last = System.currentTimeMillis();
                    Consumer<String> log = startupReportDelay < 3000L ? arg_0 -> ((Logger)LOG).debug(arg_0) : arg_0 -> ((Logger)LOG).info(arg_0);
                    log.accept("Container taking a while to start (" + Duration.millis((Number)(last - first)) + "): " + this.namespace + " " + kubeJobName + " " + result.kubePodName + " / phase '" + (Object)((Object)phase) + "'");
                    String stateJsonS = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].status.containerStatuses[0].state}'", this.namespace, kubeJobName)).summary("Get pod state").allowingNonZeroExitCode().newTask(), false, true)).get()).trim();
                    if (Strings.isNonBlank((CharSequence)stateJsonS)) {
                        log.accept("Pod state: " + stateJsonS);
                    }
                    if (Strings.isNonBlank((CharSequence)result.kubePodName)) {
                        events = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl --namespace %s get events --field-selector=involvedObject.name=%s", this.namespace, result.kubePodName)).summary("Get pod events").allowingNonZeroExitCode().newTask(), false, true)).get()).trim();
                        log.accept("Pod events: \n" + events);
                    } else {
                        events = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl --namespace %s get events --field-selector=involvedObject.name=%s", this.namespace, kubeJobName)).summary("Get job events").allowingNonZeroExitCode().newTask(), false, true)).get()).trim();
                        log.accept("Job events: \n" + events);
                    }
                    if ((startupReportDelay *= 5L) > 20000L) {
                        startupReportDelay = 20000L;
                    }
                }
                long backoffMillis2 = backoffMillis;
                Tasks.withBlockingDetails((String)("waiting " + backoffMillis2 + "ms for pod to be available (current status '" + (Object)((Object)phase) + "')"), () -> {
                    Time.sleep((long)backoffMillis2);
                    return null;
                });
                if (backoffMillis >= 80L) continue;
                backoffMillis *= 2L;
            }
            throw new IllegalStateException("Timeout waiting for pod to be available; current status is '" + (Object)((Object)phase) + "'");
        }).build(), false, true).getUnchecked());
    }

    private ContainerCommons.PodPhases checkPodPhase(Entity entity, String kubeJobName) {
        ContainerCommons.PodPhases succeeded = this.getPodPhaseFromContainerState(entity, kubeJobName);
        if (succeeded != null) {
            return succeeded;
        }
        String phase = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].status.phase}'", this.namespace, kubeJobName)).summary("Get pod phase").allowingNonZeroExitCode().newTask(), false, true)).get()).trim();
        for (ContainerCommons.PodPhases candidate : ContainerCommons.PodPhases.values()) {
            if (!candidate.name().equalsIgnoreCase(phase)) continue;
            return candidate;
        }
        return ContainerCommons.PodPhases.Unknown;
    }

    private ContainerCommons.PodPhases getPodPhaseFromContainerState(Entity entity, String kubeJobName) {
        Object stateK;
        Object stateO;
        String stateJsonS = ((String)((ProcessTaskWrapper)this.runTask(entity, this.newSimpleTaskFactory(String.format("kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].status.containerStatuses[0].state}'", this.namespace, kubeJobName)).summary("Get pod state").allowingNonZeroExitCode().newTask(), false, true)).get()).trim();
        if (Strings.isNonBlank((CharSequence)stateJsonS) && (stateO = new Gson().fromJson(stateJsonS, Object.class)) instanceof Map && !((Map)stateO).keySet().isEmpty() && (stateK = ((Map)stateO).keySet().iterator().next()) instanceof String) {
            String stateS = (String)stateK;
            if ("terminated".equalsIgnoreCase(stateS)) {
                return ContainerCommons.PodPhases.Succeeded;
            }
            if ("running".equalsIgnoreCase(stateS)) {
                return ContainerCommons.PodPhases.Running;
            }
        }
        return null;
    }

    public ProcessTaskFactory<String> newDeleteJobTask(String kubeJobName) {
        return this.newSimpleTaskFactory(String.format("kubectl delete job %s --namespace=%s", kubeJobName, this.namespace)).summary("Delete job");
    }

    private String initNamespaceAndGetNewJobName() {
        Entity entity = BrooklynTaskTags.getContextEntity((Task)Tasks.current());
        if (entity == null) {
            throw new IllegalStateException("Task must run in context of entity to background jobs");
        }
        String containerImage = (String)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.CONTAINER_IMAGE);
        if (Strings.isBlank((CharSequence)containerImage)) {
            throw new IllegalStateException("You must specify containerImage when using " + this.getClass().getSimpleName());
        }
        String cleanImageName = containerImage.contains(":") ? containerImage.substring(0, containerImage.indexOf(":")) : containerImage;
        StringShortener ss = new StringShortener().separator("-");
        if (Strings.isNonBlank((CharSequence)this.jobIdentifier)) {
            ss.append("job", this.jobIdentifier).canTruncate("job", 20);
        } else {
            ss.append("brooklyn", "brooklyn").canTruncate("brooklyn", 2);
            ss.append("appId", entity.getApplicationId()).canTruncate("appId", 4);
            ss.append("entityId", entity.getId()).canTruncate("entityId", 4);
            ss.append("image", cleanImageName).canTruncate("image", 10);
        }
        ss.append("uid", Strings.makeRandomId((int)9) + Identifiers.makeRandomPassword((int)1, (String[])new String[]{"abcdefghijklmnopqrstuvwxyz"}));
        String kubeJobName = ss.getStringOfMaxLength(50).replaceAll("[^A-Za-z0-9-]+", "-").toLowerCase();
        if (this.namespace == null) {
            this.namespace = kubeJobName;
            this.namespaceRandom = true;
        }
        return kubeJobName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ProcessTaskWrapper<String> doDeleteNamespace(boolean wait, boolean requireSuccess) {
        if (this.namespace == null) {
            return null;
        }
        Entity entity = BrooklynTaskTags.getContextEntity((Task)Tasks.current());
        if (entity == null) {
            return null;
        }
        Boolean devMode = (Boolean)EntityInitializers.resolve((ConfigBag)this.config, ContainerCommons.KEEP_CONTAINER_FOR_DEBUGGING);
        if (Boolean.TRUE.equals(devMode)) {
            return null;
        }
        LOG.debug("Deleting namespace " + this.namespace);
        ProcessTaskFactory tf = this.newSimpleTaskFactory(String.format("kubectl delete namespace %s", this.namespace)).summary("Tear down containers").allowingNonZeroExitCode();
        tf = !requireSuccess ? tf.allowingNonZeroExitCode() : tf.requiringExitCodeZero();
        ProcessTaskWrapper task = (ProcessTaskWrapper)tf.newTask();
        Entities.submit((Entity)entity, (TaskAdaptable)BrooklynTaskTags.setTransient((Task)task.asTask()));
        if (wait) {
            task.get();
            LOG.info("Deleted namespace " + this.namespace);
            System.runFinalization();
        }
        return task;
    }

    public T summary(String summary) {
        this.summary = summary;
        return this.self();
    }

    public T timeout(Duration timeout) {
        this.config.put(ContainerCommons.TIMEOUT, (Object)timeout);
        return this.self();
    }

    public T command(List<String> commands) {
        this.config.put(ContainerCommons.COMMAND, commands);
        return this.self();
    }

    public T arguments(List<String> arguments) {
        this.config.put(ContainerCommons.ARGUMENTS, arguments);
        return this.self();
    }

    public T command(String baseCommandWithNoArgs, String ... extraCommandArguments) {
        this.config.put(ContainerCommons.COMMAND, (Object)MutableList.of((Object)baseCommandWithNoArgs).appendAll(Arrays.asList(extraCommandArguments)));
        return this.self();
    }

    public T bashScriptCommands(List<String> commands) {
        this.config.put(ContainerCommons.BASH_SCRIPT, commands);
        return this.self();
    }

    public T bashScriptCommands(String firstCommandAndArgs, String ... otherCommandAndArgs) {
        return this.bashScriptCommands((List<String>)MutableList.of((Object)firstCommandAndArgs).appendAll(Arrays.asList(otherCommandAndArgs)));
    }

    public T image(String image) {
        this.config.put(ContainerCommons.CONTAINER_IMAGE, (Object)image);
        return this.self();
    }

    public T allowingNonZeroExitCode() {
        return this.allowingNonZeroExitCode(true);
    }

    public T allowingNonZeroExitCode(boolean allowNonZero) {
        this.config.put(ContainerCommons.REQUIRE_EXIT_CODE_ZERO, (Object)(!allowNonZero ? 1 : 0));
        return this.self();
    }

    public T imagePullPolicy(PullPolicy policy) {
        if (policy == null) {
            this.config.remove(ContainerCommons.CONTAINER_IMAGE_PULL_POLICY);
        } else {
            this.config.put(ContainerCommons.CONTAINER_IMAGE_PULL_POLICY, (Object)policy);
        }
        return this.self();
    }

    public T environmentVariables(Map<String, String> map) {
        return this.environmentVariablesRaw(map);
    }

    public T environmentVariablesRaw(Map<String, ?> map) {
        this.config.put(ContainerCommons.SHELL_ENVIRONMENT, (Object)MutableMap.copyOf(map));
        return this.self();
    }

    public T environmentVariable(String key, String val) {
        return this.environmentVariableRaw(key, val);
    }

    public T environmentVariableRaw(String key, Object val) {
        return this.environmentVariablesRaw((Map<String, ?>)MutableMap.copyOf((Map)((Map)this.config.get(ContainerCommons.SHELL_ENVIRONMENT))).add((Object)key, val));
    }

    public <RET2> ContainerTaskFactory<?, RET2> returning(Function<ContainerTaskResult, RET2> conversion) {
        T result = this.self();
        ((ContainerTaskFactory)result).returnConversion = conversion;
        return result;
    }

    public ContainerTaskFactory<?, String> returningStdout() {
        return this.returning(ContainerTaskResult::getMainStdout);
    }

    public ContainerTaskFactory<?, Integer> returningExitCodeAllowingNonZero() {
        return this.allowingNonZeroExitCode().returning(ContainerTaskResult::getMainExitCode);
    }

    public T useNamespace(String namespace, Boolean create, Boolean delete) {
        this.namespace = namespace;
        this.createNamespace = create;
        this.deleteNamespace = delete;
        return this.self();
    }

    public T setDeleteNamespaceAfter(Boolean delete) {
        this.deleteNamespace = delete;
        return this.self();
    }

    @Deprecated
    public T deleteNamespace(Boolean delete) {
        return this.setDeleteNamespaceAfter(delete);
    }

    public T jobIdentifier(String jobIdentifier) {
        this.jobIdentifier = jobIdentifier;
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    public T configure(Map<?, ?> flags) {
        if (flags != null) {
            this.config.putAll(flags);
        }
        return this.self();
    }

    private ProcessTaskFactory<String> newSimpleTaskFactory(String ... kubeCommands) {
        return new SystemProcessTaskFactory.ConcreteSystemProcessTaskFactory(kubeCommands).returning(ProcessTaskStub.ScriptReturnType.STDOUT_STRING).requiringExitCodeZero();
    }

    public static ConcreteContainerTaskFactory<ContainerTaskResult> newInstance() {
        return new ConcreteContainerTaskFactory<ContainerTaskResult>();
    }

    public static class ConcreteContainerTaskFactory<RET>
    extends ContainerTaskFactory<ConcreteContainerTaskFactory<RET>, RET> {
        private ConcreteContainerTaskFactory() {
        }
    }
}

