/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.features.AWSInstanceApi;
import org.jclouds.aws.ec2.features.SpotInstanceApi;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.strategy.EC2DestroyNodeStrategy;

@Singleton
public class AWSEC2DestroyNodeStrategy
extends EC2DestroyNodeStrategy {
    protected final AWSEC2Api client;
    protected final Map<String, Credentials> credentialStore;

    @Inject
    protected AWSEC2DestroyNodeStrategy(AWSEC2Api client, GetNodeMetadataStrategy getNode, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache, Map<String, Credentials> credentialStore) {
        super((EC2Api)client, getNode, elasticIpCache);
        this.client = (AWSEC2Api)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
    }

    protected void destroyInstanceInRegion(String id, String region) {
        String spotId = id;
        if (id.indexOf("sir-") != 0) {
            try {
                spotId = ((AWSRunningInstance)((Object)Iterables.getOnlyElement((Iterable)Iterables.concat(((AWSInstanceApi)this.client.getInstanceApi().get()).describeInstancesInRegion(region, id))))).getSpotInstanceRequestId();
                this.credentialStore.remove("node#" + region + "/" + spotId);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            super.destroyInstanceInRegion(id, region);
        } else {
            ((SpotInstanceApi)this.client.getSpotInstanceApi().get()).cancelSpotInstanceRequestsInRegion(region, spotId);
            this.credentialStore.remove("node#" + region + "/" + id);
        }
    }
}

