/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.options.CreateSubnetOptions;
import org.jclouds.aws.ec2.options.ModifySubnetAttributeOptions;
import org.jclouds.aws.ec2.xml.ReturnValueHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.domain.Subnet;
import org.jclouds.ec2.features.SubnetApi;
import org.jclouds.ec2.xml.DescribeSubnetsResponseHandler;
import org.jclouds.ec2.xml.SubnetHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.ApiVersionOverride;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@SinceApiVersion(value="2011-01-01")
@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface AWSSubnetApi
extends SubnetApi {
    @Named(value="CreateSubnet")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SubnetHandler.class)
    @FormParams(keys={"Action"}, values={"CreateSubnet"})
    public Subnet createSubnetInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="VpcId") String var2, @FormParam(value="CidrBlock") String var3, CreateSubnetOptions ... var4);

    @Named(value="DeleteSubnet")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteSubnet"})
    public void deleteSubnetInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SubnetId") String var2);

    @Named(value="DescribeSubnets")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSubnets"})
    @XMLResponseParser(value=DescribeSubnetsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Subnet> describeSubnetsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="DescribeSubnets")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSubnets"})
    @XMLResponseParser(value=DescribeSubnetsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Subnet> describeSubnetsInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);

    @ApiVersionOverride(value="2014-06-15")
    @Named(value="ModifySubnetAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ModifySubnetAttribute"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean modifySubnetAttribute(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SubnetId") String var2, ModifySubnetAttributeOptions var3);
}

