/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.suppliers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;

public class SupplyFromProviderURIOrNodesProperty
extends ByteSource
implements Function<URI, InputStream> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<URI> url;
    @Inject(optional=true)
    @Named(value="byon.nodes")
    @VisibleForTesting
    String nodes;

    @VisibleForTesting
    public SupplyFromProviderURIOrNodesProperty(URI url) {
        this((Supplier<URI>)Suppliers.ofInstance((Object)((URI)Preconditions.checkNotNull((Object)url, (Object)"url"))));
    }

    @Inject
    public SupplyFromProviderURIOrNodesProperty(@Provider Supplier<URI> url) {
        this.url = (Supplier)Preconditions.checkNotNull(url, (Object)"url");
    }

    public InputStream openStream() {
        if (this.nodes != null) {
            return Strings2.toInputStream((String)this.nodes);
        }
        return this.apply((URI)this.url.get());
    }

    public String toString() {
        return "[url=" + this.url + "]";
    }

    public InputStream apply(URI input) {
        try {
            if (input.getScheme() != null && input.getScheme().equals("classpath")) {
                return ((Object)((Object)this)).getClass().getResourceAsStream(input.getPath());
            }
            return input.toURL().openStream();
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "URI could not be read: %s", new Object[]{this.url});
            throw Throwables.propagate((Throwable)e);
        }
    }
}

