/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.net.HostAndPort;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClientSupport;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBDriver;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBReplicaSet;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.ReplicaSetMemberStatus;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBServerImpl
extends SoftwareProcessImpl
implements MongoDBServer {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBServerImpl.class);
    private FunctionFeed serviceStats;
    private FunctionFeed replicaSetStats;
    private MongoDBClientSupport client;

    public Class<?> getDriverInterface() {
        return MongoDBDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        int port = (Integer)this.sensors().get((AttributeSensor)MongoDBServer.PORT);
        HostAndPort accessibleAddress = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)port);
        this.sensors().set(MONGO_SERVER_ENDPOINT, (Object)String.format("%s:%d", accessibleAddress.getHost(), accessibleAddress.getPort()));
        int httpConsolePort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.sensors().get((AttributeSensor)HTTP_PORT))).getPort();
        this.sensors().set(HTTP_INTERFACE_URL, (Object)String.format("http://%s:%d", accessibleAddress.getHost(), httpConsolePort));
        if (this.clientAccessEnabled()) {
            try {
                this.client = MongoDBClientSupport.forServer(this);
            }
            catch (UnknownHostException e) {
                LOG.warn("Unable to create client connection to {}, not connecting sensors: {} ", (Object)this, (Object)e.getMessage());
                return;
            }
            this.serviceStats = FunctionFeed.builder().entity((Entity)this).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(STATUS_BSON).period(2L, TimeUnit.SECONDS)).callable((Callable)new Callable<BasicBSONObject>(){

                @Override
                public BasicBSONObject call() throws Exception {
                    return (Boolean)MongoDBServerImpl.this.sensors().get(Startable.SERVICE_UP) != false ? MongoDBServerImpl.this.client.getServerStatus() : null;
                }
            }).onException(Functions.constant(null))).build();
            if (this.isReplicaSetMember()) {
                this.replicaSetStats = FunctionFeed.builder().entity((Entity)this).poll((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(REPLICA_SET_MEMBER_STATUS).period(2L, TimeUnit.SECONDS)).callable((Callable)new Callable<ReplicaSetMemberStatus>(){

                    @Override
                    public ReplicaSetMemberStatus call() {
                        BasicBSONObject serverStatus = MongoDBServerImpl.this.client.getReplicaSetStatus();
                        int state = serverStatus.getInt("myState", -1);
                        return ReplicaSetMemberStatus.fromCode(state);
                    }
                }).onException(Functions.constant((Object)((Object)ReplicaSetMemberStatus.UNKNOWN)))).suppressDuplicates(true)).build();
            } else {
                this.sensors().set(IS_PRIMARY_FOR_REPLICA_SET, (Object)false);
                this.sensors().set(IS_SECONDARY_FOR_REPLICA_SET, (Object)false);
            }
        } else {
            LOG.info("Not monitoring " + this + " to retrieve state via client API");
        }
        this.subscriptions().subscribe((Entity)this, (Sensor)STATUS_BSON, (SensorEventListener)new SensorEventListener<BasicBSONObject>(){

            public void onEvent(SensorEvent<BasicBSONObject> event) {
                BasicBSONObject map = (BasicBSONObject)event.getValue();
                if (map != null && !map.isEmpty()) {
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.UPTIME_SECONDS, (Object)map.getDouble("uptime", 0.0));
                    BasicBSONObject opcounters = (BasicBSONObject)map.get("opcounters");
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.OPCOUNTERS_INSERTS, (Object)opcounters.getLong("insert", 0L));
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.OPCOUNTERS_QUERIES, (Object)opcounters.getLong("query", 0L));
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.OPCOUNTERS_UPDATES, (Object)opcounters.getLong("update", 0L));
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.OPCOUNTERS_DELETES, (Object)opcounters.getLong("delete", 0L));
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.OPCOUNTERS_GETMORE, (Object)opcounters.getLong("getmore", 0L));
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.OPCOUNTERS_COMMAND, (Object)opcounters.getLong("command", 0L));
                    BasicBSONObject network = (BasicBSONObject)map.get("network");
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.NETWORK_BYTES_IN, (Object)network.getLong("bytesIn", 0L));
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.NETWORK_BYTES_OUT, (Object)network.getLong("bytesOut", 0L));
                    MongoDBServerImpl.this.sensors().set(MongoDBServer.NETWORK_NUM_REQUESTS, (Object)network.getLong("numRequests", 0L));
                    BasicBSONObject repl = (BasicBSONObject)map.get("repl");
                    if (MongoDBServerImpl.this.isReplicaSetMember() && repl != null) {
                        MongoDBServerImpl.this.sensors().set(MongoDBServer.IS_PRIMARY_FOR_REPLICA_SET, (Object)repl.getBoolean("ismaster"));
                        MongoDBServerImpl.this.sensors().set(MongoDBServer.IS_SECONDARY_FOR_REPLICA_SET, (Object)repl.getBoolean("secondary"));
                        MongoDBServerImpl.this.sensors().set(MongoDBServer.REPLICA_SET_PRIMARY_ENDPOINT, (Object)repl.getString("primary"));
                    }
                }
            }
        });
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.serviceStats != null) {
            this.serviceStats.stop();
        }
        if (this.replicaSetStats != null) {
            this.replicaSetStats.stop();
        }
    }

    protected boolean clientAccessEnabled() {
        return Boolean.TRUE.equals(this.config().get(MongoDBServer.USE_CLIENT_MONITORING));
    }

    @Override
    public MongoDBReplicaSet getReplicaSet() {
        return (MongoDBReplicaSet)this.config().get(MongoDBServer.REPLICA_SET);
    }

    @Override
    public boolean isReplicaSetMember() {
        return this.getReplicaSet() != null;
    }

    @Override
    public boolean initializeReplicaSet(String replicaSetName, Integer id) {
        return this.client.initializeReplicaSet(replicaSetName, id);
    }

    @Override
    public boolean addMemberToReplicaSet(MongoDBServer secondary, Integer id) {
        if (!((Boolean)this.sensors().get(IS_PRIMARY_FOR_REPLICA_SET)).booleanValue()) {
            LOG.warn("Attempted to add {} to replica set at server that is not primary: {}", (Object)secondary, (Object)this);
            return false;
        }
        if (!this.clientAccessEnabled()) {
            throw new IllegalStateException("client-access disabled for " + this + "; cannot add to replica set member " + secondary + " -> " + id);
        }
        return this.client.addMemberToReplicaSet(secondary, id);
    }

    @Override
    public boolean removeMemberFromReplicaSet(MongoDBServer server) {
        if (!((Boolean)this.sensors().get(IS_PRIMARY_FOR_REPLICA_SET)).booleanValue()) {
            LOG.warn("Attempted to remove {} from replica set at server that is not primary: {}", (Object)server, (Object)this);
            return false;
        }
        if (!this.clientAccessEnabled()) {
            throw new IllegalStateException("client-access disabled for " + this + "; cannot remove from replica set member " + server);
        }
        return this.client.removeMemberFromReplicaSet(server);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("hostname", this.sensors().get(HOSTNAME)).add("port", this.sensors().get((AttributeSensor)PORT)).toString();
    }

    static {
        RendererHints.register((AttributeSensor)HTTP_INTERFACE_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

