/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.functions;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.auth.AuthenticationApi;
import org.jclouds.openstack.keystone.auth.config.CredentialType;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.domain.PasswordCredentials;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.auth.functions.BaseAuthenticator;

@CredentialType(value="passwordCredentials")
@Singleton
public class AuthenticatePasswordCredentials
extends BaseAuthenticator<PasswordCredentials> {
    private final AuthenticationApi auth;

    @Inject
    AuthenticatePasswordCredentials(AuthenticationApi auth) {
        this.auth = auth;
    }

    @Override
    public PasswordCredentials createCredentials(String identity, String credential) {
        return PasswordCredentials.builder().username(identity).password(credential).build();
    }

    @Override
    public AuthInfo authenticate(TenantOrDomainAndCredentials<PasswordCredentials> credentials) {
        return this.auth.authenticatePassword(credentials);
    }
}

