/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.entity.helm;

import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.container.entity.helm.HelmEntityImpl;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.Sensors;

@ImplementedBy(value=HelmEntityImpl.class)
public interface HelmEntity
extends Entity,
Startable {
    public static final ConfigKey<String> REPO_NAME = ConfigKeys.newStringConfigKey((String)"repo.name", (String)"Name for the Helm repository");
    public static final ConfigKey<String> REPO_URL = ConfigKeys.newStringConfigKey((String)"repo.url", (String)"URL of a Helm repository");
    public static final ConfigKey<String> HELM_TEMPLATE = ConfigKeys.newStringConfigKey((String)"helm.template", (String)"The name of the Helm template to be deployed");
    public static final ConfigKey<String> HELM_DEPLOYMENT_NAME = ConfigKeys.newStringConfigKey((String)"helm.deployment.name", (String)"The name to use for the Helm deployment");
    public static final ConfigKey<String> HELM_INSTALL_VALUES = ConfigKeys.newStringConfigKey((String)"helm.install.values", (String)"A file or URL with a set of Helm config values to use at install time");
    public static final AttributeSensor<String> STATUS = Sensors.newStringSensor((String)"helm.status", (String)"The status of the Helm deployment");
    public static final AttributeSensor<Boolean> DEPLOYMENT_READY = Sensors.newBooleanSensor((String)"kube.deployment.status", (String)"The status of the Kubernetes Deployment resource");
    public static final AttributeSensor<List<String>> DEPLOYMENTS = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"kube.deployments", (String)"List of Kubernetes Deployment resources");
    public static final AttributeSensor<List<String>> SERVICES = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"kube.services", (String)"List of Kubernetes Service resources");

    @Effector(description="Resize Helm deployment")
    public Integer resize(@EffectorParam(name="deploymentName") String var1, @EffectorParam(name="desiredSize") Integer var2);
}

