/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.calendar.internal;

import java.lang.reflect.Method;
import java.util.List;

import com.google.api.services.calendar.Calendar.CalendarList;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;
import static org.apache.camel.support.component.ApiMethodArg.setter;

/**
 * Camel {@link ApiMethod} Enumeration for com.google.api.services.calendar.Calendar$CalendarList
 */
public enum CalendarCalendarListApiMethod implements ApiMethod {

    DELETE(
        com.google.api.services.calendar.Calendar.CalendarList.Delete.class,
        "delete",
        arg("calendarId", String.class)),

    GET(
        com.google.api.services.calendar.Calendar.CalendarList.Get.class,
        "get",
        arg("calendarId", String.class)),

    INSERT(
        com.google.api.services.calendar.Calendar.CalendarList.Insert.class,
        "insert",
        arg("content", com.google.api.services.calendar.model.CalendarListEntry.class),
        setter("colorRgbFormat", Boolean.class)),

    LIST(
        com.google.api.services.calendar.Calendar.CalendarList.List.class,
        "list",
        setter("maxResults", Integer.class),
        setter("minAccessRole", String.class),
        setter("pageToken", String.class),
        setter("showDeleted", Boolean.class),
        setter("showHidden", Boolean.class),
        setter("syncToken", String.class)),

    PATCH(
        com.google.api.services.calendar.Calendar.CalendarList.Patch.class,
        "patch",
        arg("calendarId", String.class),
        arg("content", com.google.api.services.calendar.model.CalendarListEntry.class),
        setter("colorRgbFormat", Boolean.class)),

    UPDATE(
        com.google.api.services.calendar.Calendar.CalendarList.Update.class,
        "update",
        arg("calendarId", String.class),
        arg("content", com.google.api.services.calendar.model.CalendarListEntry.class),
        setter("colorRgbFormat", Boolean.class)),

    WATCH(
        com.google.api.services.calendar.Calendar.CalendarList.Watch.class,
        "watch",
        arg("contentChannel", com.google.api.services.calendar.model.Channel.class),
        setter("maxResults", Integer.class),
        setter("minAccessRole", String.class),
        setter("pageToken", String.class),
        setter("showDeleted", Boolean.class),
        setter("showHidden", Boolean.class),
        setter("syncToken", String.class));

    private final ApiMethod apiMethod;

    CalendarCalendarListApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(CalendarList.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<String> getSetterArgNames() { return apiMethod.getSetterArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
