/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.docling.DoclingComponent;

/**
 * Process documents using Docling library for parsing and conversion.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DoclingComponentBuilderFactory {

    /**
     * Docling (camel-docling)
     * Process documents using Docling library for parsing and conversion.
     * 
     * Category: transformation,ai
     * Since: 4.15
     * Maven coordinates: org.apache.camel:camel-docling
     * 
     * @return the dsl builder
     */
    static DoclingComponentBuilder docling() {
        return new DoclingComponentBuilderImpl();
    }

    /**
     * Builder for the Docling component.
     */
    interface DoclingComponentBuilder extends ComponentBuilder<DoclingComponent> {
    
        /**
         * The configuration for the Docling Endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.docling.DoclingConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder configuration(org.apache.camel.component.docling.DoclingConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * Include the content of the output file in the exchange body and
         * delete the output file.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentInBody the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder contentInBody(boolean contentInBody) {
            doSetProperty("contentInBody", contentInBody);
            return this;
        }
    
        
        /**
         * Enable OCR processing for scanned documents.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param enableOCR the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder enableOCR(boolean enableOCR) {
            doSetProperty("enableOCR", enableOCR);
            return this;
        }
    
        
        /**
         * Show layout information with bounding boxes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param includeLayoutInfo the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder includeLayoutInfo(boolean includeLayoutInfo) {
            doSetProperty("includeLayoutInfo", includeLayoutInfo);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Language code for OCR processing.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: en
         * Group: producer
         * 
         * @param ocrLanguage the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder ocrLanguage(java.lang.String ocrLanguage) {
            doSetProperty("ocrLanguage", ocrLanguage);
            return this;
        }
    
        
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.docling.DoclingOperations&lt;/code&gt; type.
         * 
         * Default: CONVERT_TO_MARKDOWN
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder operation(org.apache.camel.component.docling.DoclingOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * Output format for document conversion.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: markdown
         * Group: producer
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder outputFormat(java.lang.String outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * Path to Docling Python executable or command.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param doclingCommand the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder doclingCommand(java.lang.String doclingCommand) {
            doSetProperty("doclingCommand", doclingCommand);
            return this;
        }
    
        
        /**
         * Timeout for Docling process execution in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param processTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder processTimeout(long processTimeout) {
            doSetProperty("processTimeout", processTimeout);
            return this;
        }
    
        /**
         * Working directory for Docling execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workingDirectory the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder workingDirectory(java.lang.String workingDirectory) {
            doSetProperty("workingDirectory", workingDirectory);
            return this;
        }
    
        
        /**
         * Maximum file size in bytes for processing.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 52428800
         * Group: security
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder maxFileSize(long maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
    }

    class DoclingComponentBuilderImpl
            extends AbstractComponentBuilder<DoclingComponent>
            implements DoclingComponentBuilder {
        @Override
        protected DoclingComponent buildConcreteComponent() {
            return new DoclingComponent();
        }
        private org.apache.camel.component.docling.DoclingConfiguration getOrCreateConfiguration(DoclingComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.docling.DoclingConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((DoclingComponent) component).setConfiguration((org.apache.camel.component.docling.DoclingConfiguration) value); return true;
            case "contentInBody": getOrCreateConfiguration((DoclingComponent) component).setContentInBody((boolean) value); return true;
            case "enableOCR": getOrCreateConfiguration((DoclingComponent) component).setEnableOCR((boolean) value); return true;
            case "includeLayoutInfo": getOrCreateConfiguration((DoclingComponent) component).setIncludeLayoutInfo((boolean) value); return true;
            case "lazyStartProducer": ((DoclingComponent) component).setLazyStartProducer((boolean) value); return true;
            case "ocrLanguage": getOrCreateConfiguration((DoclingComponent) component).setOcrLanguage((java.lang.String) value); return true;
            case "operation": getOrCreateConfiguration((DoclingComponent) component).setOperation((org.apache.camel.component.docling.DoclingOperations) value); return true;
            case "outputFormat": getOrCreateConfiguration((DoclingComponent) component).setOutputFormat((java.lang.String) value); return true;
            case "autowiredEnabled": ((DoclingComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "doclingCommand": getOrCreateConfiguration((DoclingComponent) component).setDoclingCommand((java.lang.String) value); return true;
            case "processTimeout": getOrCreateConfiguration((DoclingComponent) component).setProcessTimeout((long) value); return true;
            case "workingDirectory": getOrCreateConfiguration((DoclingComponent) component).setWorkingDirectory((java.lang.String) value); return true;
            case "maxFileSize": getOrCreateConfiguration((DoclingComponent) component).setMaxFileSize((long) value); return true;
            default: return false;
            }
        }
    }
}