/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Transfer data securely and reliably using the AS2 protocol (RFC4130).
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AS2EndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the AS2 component.
     */
    public interface AS2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAS2EndpointConsumerBuilder advanced() {
            return (AdvancedAS2EndpointConsumerBuilder) this;
        }
        /**
         * The value of the AS2From header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param as2From the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2From(String as2From) {
            doSetProperty("as2From", as2From);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2MessageStructure</code>
         * type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2MessageStructure(org.apache.camel.component.as2.api.AS2MessageStructure as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2MessageStructure</code>
         * type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2MessageStructure(String as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The value of the AS2To header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param as2To the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2To(String as2To) {
            doSetProperty("as2To", as2To);
            return this;
        }
        /**
         * The version of the AS2 protocol.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 1.1
         * Group: common
         * 
         * @param as2Version the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2Version(String as2Version) {
            doSetProperty("as2Version", as2Version);
            return this;
        }
        /**
         * The port number of asynchronous MDN server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         * 
         * @param asyncMdnPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder asyncMdnPortNumber(Integer asyncMdnPortNumber) {
            doSetProperty("asyncMdnPortNumber", asyncMdnPortNumber);
            return this;
        }
        /**
         * The port number of asynchronous MDN server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         * 
         * @param asyncMdnPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder asyncMdnPortNumber(String asyncMdnPortNumber) {
            doSetProperty("asyncMdnPortNumber", asyncMdnPortNumber);
            return this;
        }
        /**
         * The name of the attached file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param attachedFileName the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder attachedFileName(String attachedFileName) {
            doSetProperty("attachedFileName", attachedFileName);
            return this;
        }
        /**
         * The Client Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param clientFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder clientFqdn(String clientFqdn) {
            doSetProperty("clientFqdn", clientFqdn);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2CompressionAlgorithm</code> type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder compressionAlgorithm(org.apache.camel.component.as2.api.AS2CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2CompressionAlgorithm</code> type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder compressionAlgorithm(String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The value of the Disposition-Notification-To header. Assigning a
         * value to this parameter requests a message disposition notification
         * (MDN) for the AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param dispositionNotificationTo the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder dispositionNotificationTo(String dispositionNotificationTo) {
            doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }
        /**
         * The charset of the content type of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: us-ascii
         * Group: common
         * 
         * @param ediMessageCharset the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder ediMessageCharset(String ediMessageCharset) {
            doSetProperty("ediMessageCharset", ediMessageCharset);
            return this;
        }
        /**
         * The transfer encoding of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param ediMessageTransferEncoding the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder ediMessageTransferEncoding(String ediMessageTransferEncoding) {
            doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent, application/xml.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder ediMessageType(String ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The value of the From header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * The maximum size of the connection pool for http connections (client
         * only).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpConnectionPoolSize the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpConnectionPoolSize(Integer httpConnectionPoolSize) {
            doSetProperty("httpConnectionPoolSize", httpConnectionPoolSize);
            return this;
        }
        /**
         * The maximum size of the connection pool for http connections (client
         * only).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpConnectionPoolSize the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpConnectionPoolSize(String httpConnectionPoolSize) {
            doSetProperty("httpConnectionPoolSize", httpConnectionPoolSize);
            return this;
        }
        /**
         * The time to live for connections in the connection pool (client
         * only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 15m
         * Group: common
         * 
         * @param httpConnectionPoolTtl the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpConnectionPoolTtl(java.time.Duration httpConnectionPoolTtl) {
            doSetProperty("httpConnectionPoolTtl", httpConnectionPoolTtl);
            return this;
        }
        /**
         * The time to live for connections in the connection pool (client
         * only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 15m
         * Group: common
         * 
         * @param httpConnectionPoolTtl the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpConnectionPoolTtl(String httpConnectionPoolTtl) {
            doSetProperty("httpConnectionPoolTtl", httpConnectionPoolTtl);
            return this;
        }
        /**
         * The timeout of the http connection (client only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpConnectionTimeout(java.time.Duration httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * The timeout of the http connection (client only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpConnectionTimeout(String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * The timeout of the underlying http socket (client only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpSocketTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpSocketTimeout(java.time.Duration httpSocketTimeout) {
            doSetProperty("httpSocketTimeout", httpSocketTimeout);
            return this;
        }
        /**
         * The timeout of the underlying http socket (client only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpSocketTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder httpSocketTimeout(String httpSocketTimeout) {
            doSetProperty("httpSocketTimeout", httpSocketTimeout);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The template used to format MDN message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param mdnMessageTemplate the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder mdnMessageTemplate(String mdnMessageTemplate) {
            doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }
        /**
         * The return URL that the message receiver should send an asynchronous
         * MDN to. If not present the receipt is synchronous. (Client only).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param receiptDeliveryOption the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder receiptDeliveryOption(String receiptDeliveryOption) {
            doSetProperty("receiptDeliveryOption", receiptDeliveryOption);
            return this;
        }
        /**
         * The request URI of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /
         * Group: common
         * 
         * @param requestUri the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder requestUri(String requestUri) {
            doSetProperty("requestUri", requestUri);
            return this;
        }
        /**
         * The value included in the Server message header identifying the AS2
         * Server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Camel AS2 Server Endpoint
         * Group: common
         * 
         * @param server the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder server(String server) {
            doSetProperty("server", server);
            return this;
        }
        /**
         * The Server Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param serverFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder serverFqdn(String serverFqdn) {
            doSetProperty("serverFqdn", serverFqdn);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder serverPortNumber(Integer serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder serverPortNumber(String serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The value of Subject header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The host name (IP or DNS name) of target host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param targetHostname the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder targetHostname(String targetHostname) {
            doSetProperty("targetHostname", targetHostname);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 80
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder targetPortNumber(Integer targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 80
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder targetPortNumber(String targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The value included in the User-Agent message header identifying the
         * AS2 user agent.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Camel AS2 Client Endpoint
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * The access token that is used by the client for bearer
         * authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessToken the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option is a: <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder decryptingPrivateKey(java.security.PrivateKey decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder decryptingPrivateKey(String decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2EncryptionAlgorithm</code> type.
         * 
         * Group: security
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingAlgorithm(org.apache.camel.component.as2.api.AS2EncryptionAlgorithm encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2EncryptionAlgorithm</code> type.
         * 
         * Group: security
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingAlgorithm(String encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingCertificateChain(java.security.cert.Certificate[] encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingCertificateChain(String encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * Set hostname verifier for SSL session.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder hostnameVerifier(javax.net.ssl.HostnameVerifier hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * Set hostname verifier for SSL session.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder hostnameVerifier(String hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * The access token that is used by the server when it sends an async
         * MDN.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnAccessToken the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder mdnAccessToken(String mdnAccessToken) {
            doSetProperty("mdnAccessToken", mdnAccessToken);
            return this;
        }
        /**
         * The password that is used by the server for basic authentication when
         * it sends an async MDN.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnPassword the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder mdnPassword(String mdnPassword) {
            doSetProperty("mdnPassword", mdnPassword);
            return this;
        }
        /**
         * The user-name that is used by the server for basic authentication
         * when it sends an async MDN. If options for basic authentication and
         * bearer authentication are both set then basic authentication takes
         * precedence.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnUserName the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder mdnUserName(String mdnUserName) {
            doSetProperty("mdnUserName", mdnUserName);
            return this;
        }
        /**
         * The password that is used by the client for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message disposition
         * notification (MDN). Multiple algorithms can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signedReceiptMicAlgorithms(String signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2SignatureAlgorithm</code>
         * type.
         * 
         * Group: security
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingAlgorithm(org.apache.camel.component.as2.api.AS2SignatureAlgorithm signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2SignatureAlgorithm</code>
         * type.
         * 
         * Group: security
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingAlgorithm(String signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingCertificateChain(java.security.cert.Certificate[] signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingCertificateChain(String signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option is a: <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingPrivateKey(java.security.PrivateKey signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingPrivateKey(String signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * Set SSL context for connection to remote server.
         * 
         * The option is a: <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder sslContext(javax.net.ssl.SSLContext sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * Set SSL context for connection to remote server.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * The user-name that is used by the client for basic authentication. If
         * options for basic authentication and bearer authentication are both
         * set then basic authentication takes precedence.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Certificates to validate the message's signature against. If not
         * supplied, validation will not take place. Server: validates the
         * received message. Client: not yet implemented, should validate the
         * MDN.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param validateSigningCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder validateSigningCertificateChain(java.security.cert.Certificate[] validateSigningCertificateChain) {
            doSetProperty("validateSigningCertificateChain", validateSigningCertificateChain);
            return this;
        }
        /**
         * Certificates to validate the message's signature against. If not
         * supplied, validation will not take place. Server: validates the
         * received message. Client: not yet implemented, should validate the
         * MDN.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param validateSigningCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder validateSigningCertificateChain(String validateSigningCertificateChain) {
            doSetProperty("validateSigningCertificateChain", validateSigningCertificateChain);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AS2 component.
     */
    public interface AdvancedAS2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AS2EndpointConsumerBuilder basic() {
            return (AS2EndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AS2 component.
     */
    public interface AS2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAS2EndpointProducerBuilder advanced() {
            return (AdvancedAS2EndpointProducerBuilder) this;
        }

        /**
         * The value of the AS2From header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param as2From the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2From(String as2From) {
            doSetProperty("as2From", as2From);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2MessageStructure</code>
         * type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2MessageStructure(org.apache.camel.component.as2.api.AS2MessageStructure as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2MessageStructure</code>
         * type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2MessageStructure(String as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The value of the AS2To header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param as2To the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2To(String as2To) {
            doSetProperty("as2To", as2To);
            return this;
        }
        /**
         * The version of the AS2 protocol.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 1.1
         * Group: common
         * 
         * @param as2Version the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2Version(String as2Version) {
            doSetProperty("as2Version", as2Version);
            return this;
        }
        /**
         * The port number of asynchronous MDN server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         * 
         * @param asyncMdnPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder asyncMdnPortNumber(Integer asyncMdnPortNumber) {
            doSetProperty("asyncMdnPortNumber", asyncMdnPortNumber);
            return this;
        }
        /**
         * The port number of asynchronous MDN server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         * 
         * @param asyncMdnPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder asyncMdnPortNumber(String asyncMdnPortNumber) {
            doSetProperty("asyncMdnPortNumber", asyncMdnPortNumber);
            return this;
        }
        /**
         * The name of the attached file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param attachedFileName the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder attachedFileName(String attachedFileName) {
            doSetProperty("attachedFileName", attachedFileName);
            return this;
        }
        /**
         * The Client Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param clientFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder clientFqdn(String clientFqdn) {
            doSetProperty("clientFqdn", clientFqdn);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2CompressionAlgorithm</code> type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder compressionAlgorithm(org.apache.camel.component.as2.api.AS2CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2CompressionAlgorithm</code> type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder compressionAlgorithm(String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The value of the Disposition-Notification-To header. Assigning a
         * value to this parameter requests a message disposition notification
         * (MDN) for the AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param dispositionNotificationTo the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder dispositionNotificationTo(String dispositionNotificationTo) {
            doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }
        /**
         * The charset of the content type of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: us-ascii
         * Group: common
         * 
         * @param ediMessageCharset the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder ediMessageCharset(String ediMessageCharset) {
            doSetProperty("ediMessageCharset", ediMessageCharset);
            return this;
        }
        /**
         * The transfer encoding of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param ediMessageTransferEncoding the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder ediMessageTransferEncoding(String ediMessageTransferEncoding) {
            doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent, application/xml.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder ediMessageType(String ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The value of the From header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * The maximum size of the connection pool for http connections (client
         * only).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpConnectionPoolSize the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpConnectionPoolSize(Integer httpConnectionPoolSize) {
            doSetProperty("httpConnectionPoolSize", httpConnectionPoolSize);
            return this;
        }
        /**
         * The maximum size of the connection pool for http connections (client
         * only).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpConnectionPoolSize the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpConnectionPoolSize(String httpConnectionPoolSize) {
            doSetProperty("httpConnectionPoolSize", httpConnectionPoolSize);
            return this;
        }
        /**
         * The time to live for connections in the connection pool (client
         * only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 15m
         * Group: common
         * 
         * @param httpConnectionPoolTtl the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpConnectionPoolTtl(java.time.Duration httpConnectionPoolTtl) {
            doSetProperty("httpConnectionPoolTtl", httpConnectionPoolTtl);
            return this;
        }
        /**
         * The time to live for connections in the connection pool (client
         * only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 15m
         * Group: common
         * 
         * @param httpConnectionPoolTtl the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpConnectionPoolTtl(String httpConnectionPoolTtl) {
            doSetProperty("httpConnectionPoolTtl", httpConnectionPoolTtl);
            return this;
        }
        /**
         * The timeout of the http connection (client only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpConnectionTimeout(java.time.Duration httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * The timeout of the http connection (client only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpConnectionTimeout(String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * The timeout of the underlying http socket (client only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpSocketTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpSocketTimeout(java.time.Duration httpSocketTimeout) {
            doSetProperty("httpSocketTimeout", httpSocketTimeout);
            return this;
        }
        /**
         * The timeout of the underlying http socket (client only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpSocketTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder httpSocketTimeout(String httpSocketTimeout) {
            doSetProperty("httpSocketTimeout", httpSocketTimeout);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The template used to format MDN message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param mdnMessageTemplate the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder mdnMessageTemplate(String mdnMessageTemplate) {
            doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }
        /**
         * The return URL that the message receiver should send an asynchronous
         * MDN to. If not present the receipt is synchronous. (Client only).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param receiptDeliveryOption the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder receiptDeliveryOption(String receiptDeliveryOption) {
            doSetProperty("receiptDeliveryOption", receiptDeliveryOption);
            return this;
        }
        /**
         * The request URI of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /
         * Group: common
         * 
         * @param requestUri the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder requestUri(String requestUri) {
            doSetProperty("requestUri", requestUri);
            return this;
        }
        /**
         * The value included in the Server message header identifying the AS2
         * Server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Camel AS2 Server Endpoint
         * Group: common
         * 
         * @param server the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder server(String server) {
            doSetProperty("server", server);
            return this;
        }
        /**
         * The Server Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param serverFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder serverFqdn(String serverFqdn) {
            doSetProperty("serverFqdn", serverFqdn);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder serverPortNumber(Integer serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder serverPortNumber(String serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The value of Subject header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The host name (IP or DNS name) of target host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param targetHostname the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder targetHostname(String targetHostname) {
            doSetProperty("targetHostname", targetHostname);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 80
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder targetPortNumber(Integer targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 80
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder targetPortNumber(String targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The value included in the User-Agent message header identifying the
         * AS2 user agent.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Camel AS2 Client Endpoint
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * The access token that is used by the client for bearer
         * authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessToken the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option is a: <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder decryptingPrivateKey(java.security.PrivateKey decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder decryptingPrivateKey(String decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2EncryptionAlgorithm</code> type.
         * 
         * Group: security
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingAlgorithm(org.apache.camel.component.as2.api.AS2EncryptionAlgorithm encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2EncryptionAlgorithm</code> type.
         * 
         * Group: security
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingAlgorithm(String encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingCertificateChain(java.security.cert.Certificate[] encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingCertificateChain(String encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * Set hostname verifier for SSL session.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder hostnameVerifier(javax.net.ssl.HostnameVerifier hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * Set hostname verifier for SSL session.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder hostnameVerifier(String hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * The access token that is used by the server when it sends an async
         * MDN.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnAccessToken the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder mdnAccessToken(String mdnAccessToken) {
            doSetProperty("mdnAccessToken", mdnAccessToken);
            return this;
        }
        /**
         * The password that is used by the server for basic authentication when
         * it sends an async MDN.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnPassword the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder mdnPassword(String mdnPassword) {
            doSetProperty("mdnPassword", mdnPassword);
            return this;
        }
        /**
         * The user-name that is used by the server for basic authentication
         * when it sends an async MDN. If options for basic authentication and
         * bearer authentication are both set then basic authentication takes
         * precedence.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnUserName the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder mdnUserName(String mdnUserName) {
            doSetProperty("mdnUserName", mdnUserName);
            return this;
        }
        /**
         * The password that is used by the client for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message disposition
         * notification (MDN). Multiple algorithms can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signedReceiptMicAlgorithms(String signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2SignatureAlgorithm</code>
         * type.
         * 
         * Group: security
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingAlgorithm(org.apache.camel.component.as2.api.AS2SignatureAlgorithm signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2SignatureAlgorithm</code>
         * type.
         * 
         * Group: security
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingAlgorithm(String signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingCertificateChain(java.security.cert.Certificate[] signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingCertificateChain(String signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option is a: <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingPrivateKey(java.security.PrivateKey signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingPrivateKey(String signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * Set SSL context for connection to remote server.
         * 
         * The option is a: <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder sslContext(javax.net.ssl.SSLContext sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * Set SSL context for connection to remote server.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * The user-name that is used by the client for basic authentication. If
         * options for basic authentication and bearer authentication are both
         * set then basic authentication takes precedence.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Certificates to validate the message's signature against. If not
         * supplied, validation will not take place. Server: validates the
         * received message. Client: not yet implemented, should validate the
         * MDN.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param validateSigningCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder validateSigningCertificateChain(java.security.cert.Certificate[] validateSigningCertificateChain) {
            doSetProperty("validateSigningCertificateChain", validateSigningCertificateChain);
            return this;
        }
        /**
         * Certificates to validate the message's signature against. If not
         * supplied, validation will not take place. Server: validates the
         * received message. Client: not yet implemented, should validate the
         * MDN.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param validateSigningCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder validateSigningCertificateChain(String validateSigningCertificateChain) {
            doSetProperty("validateSigningCertificateChain", validateSigningCertificateChain);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AS2 component.
     */
    public interface AdvancedAS2EndpointProducerBuilder extends EndpointProducerBuilder {
        default AS2EndpointProducerBuilder basic() {
            return (AS2EndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AS2 component.
     */
    public interface AS2EndpointBuilder
            extends
                AS2EndpointConsumerBuilder,
                AS2EndpointProducerBuilder {
        default AdvancedAS2EndpointBuilder advanced() {
            return (AdvancedAS2EndpointBuilder) this;
        }

        /**
         * The value of the AS2From header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param as2From the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2From(String as2From) {
            doSetProperty("as2From", as2From);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2MessageStructure</code>
         * type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2MessageStructure(org.apache.camel.component.as2.api.AS2MessageStructure as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2MessageStructure</code>
         * type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2MessageStructure(String as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The value of the AS2To header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param as2To the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2To(String as2To) {
            doSetProperty("as2To", as2To);
            return this;
        }
        /**
         * The version of the AS2 protocol.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 1.1
         * Group: common
         * 
         * @param as2Version the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2Version(String as2Version) {
            doSetProperty("as2Version", as2Version);
            return this;
        }
        /**
         * The port number of asynchronous MDN server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         * 
         * @param asyncMdnPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder asyncMdnPortNumber(Integer asyncMdnPortNumber) {
            doSetProperty("asyncMdnPortNumber", asyncMdnPortNumber);
            return this;
        }
        /**
         * The port number of asynchronous MDN server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         * 
         * @param asyncMdnPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder asyncMdnPortNumber(String asyncMdnPortNumber) {
            doSetProperty("asyncMdnPortNumber", asyncMdnPortNumber);
            return this;
        }
        /**
         * The name of the attached file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param attachedFileName the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder attachedFileName(String attachedFileName) {
            doSetProperty("attachedFileName", attachedFileName);
            return this;
        }
        /**
         * The Client Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param clientFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder clientFqdn(String clientFqdn) {
            doSetProperty("clientFqdn", clientFqdn);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2CompressionAlgorithm</code> type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder compressionAlgorithm(org.apache.camel.component.as2.api.AS2CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2CompressionAlgorithm</code> type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder compressionAlgorithm(String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The value of the Disposition-Notification-To header. Assigning a
         * value to this parameter requests a message disposition notification
         * (MDN) for the AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param dispositionNotificationTo the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder dispositionNotificationTo(String dispositionNotificationTo) {
            doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }
        /**
         * The charset of the content type of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: us-ascii
         * Group: common
         * 
         * @param ediMessageCharset the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder ediMessageCharset(String ediMessageCharset) {
            doSetProperty("ediMessageCharset", ediMessageCharset);
            return this;
        }
        /**
         * The transfer encoding of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param ediMessageTransferEncoding the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder ediMessageTransferEncoding(String ediMessageTransferEncoding) {
            doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent, application/xml.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder ediMessageType(String ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The value of the From header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * The maximum size of the connection pool for http connections (client
         * only).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpConnectionPoolSize the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpConnectionPoolSize(Integer httpConnectionPoolSize) {
            doSetProperty("httpConnectionPoolSize", httpConnectionPoolSize);
            return this;
        }
        /**
         * The maximum size of the connection pool for http connections (client
         * only).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpConnectionPoolSize the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpConnectionPoolSize(String httpConnectionPoolSize) {
            doSetProperty("httpConnectionPoolSize", httpConnectionPoolSize);
            return this;
        }
        /**
         * The time to live for connections in the connection pool (client
         * only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 15m
         * Group: common
         * 
         * @param httpConnectionPoolTtl the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpConnectionPoolTtl(java.time.Duration httpConnectionPoolTtl) {
            doSetProperty("httpConnectionPoolTtl", httpConnectionPoolTtl);
            return this;
        }
        /**
         * The time to live for connections in the connection pool (client
         * only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 15m
         * Group: common
         * 
         * @param httpConnectionPoolTtl the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpConnectionPoolTtl(String httpConnectionPoolTtl) {
            doSetProperty("httpConnectionPoolTtl", httpConnectionPoolTtl);
            return this;
        }
        /**
         * The timeout of the http connection (client only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpConnectionTimeout(java.time.Duration httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * The timeout of the http connection (client only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpConnectionTimeout(String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * The timeout of the underlying http socket (client only).
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpSocketTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpSocketTimeout(java.time.Duration httpSocketTimeout) {
            doSetProperty("httpSocketTimeout", httpSocketTimeout);
            return this;
        }
        /**
         * The timeout of the underlying http socket (client only).
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 5s
         * Group: common
         * 
         * @param httpSocketTimeout the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder httpSocketTimeout(String httpSocketTimeout) {
            doSetProperty("httpSocketTimeout", httpSocketTimeout);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The template used to format MDN message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param mdnMessageTemplate the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder mdnMessageTemplate(String mdnMessageTemplate) {
            doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }
        /**
         * The return URL that the message receiver should send an asynchronous
         * MDN to. If not present the receipt is synchronous. (Client only).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param receiptDeliveryOption the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder receiptDeliveryOption(String receiptDeliveryOption) {
            doSetProperty("receiptDeliveryOption", receiptDeliveryOption);
            return this;
        }
        /**
         * The request URI of EDI message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /
         * Group: common
         * 
         * @param requestUri the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder requestUri(String requestUri) {
            doSetProperty("requestUri", requestUri);
            return this;
        }
        /**
         * The value included in the Server message header identifying the AS2
         * Server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Camel AS2 Server Endpoint
         * Group: common
         * 
         * @param server the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder server(String server) {
            doSetProperty("server", server);
            return this;
        }
        /**
         * The Server Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param serverFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder serverFqdn(String serverFqdn) {
            doSetProperty("serverFqdn", serverFqdn);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder serverPortNumber(Integer serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder serverPortNumber(String serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The value of Subject header of AS2 message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The host name (IP or DNS name) of target host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param targetHostname the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder targetHostname(String targetHostname) {
            doSetProperty("targetHostname", targetHostname);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 80
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder targetPortNumber(Integer targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 80
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder targetPortNumber(String targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The value included in the User-Agent message header identifying the
         * AS2 user agent.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Camel AS2 Client Endpoint
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * The access token that is used by the client for bearer
         * authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessToken the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option is a: <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder decryptingPrivateKey(java.security.PrivateKey decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder decryptingPrivateKey(String decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2EncryptionAlgorithm</code> type.
         * 
         * Group: security
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingAlgorithm(org.apache.camel.component.as2.api.AS2EncryptionAlgorithm encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2EncryptionAlgorithm</code> type.
         * 
         * Group: security
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingAlgorithm(String encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingCertificateChain(java.security.cert.Certificate[] encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingCertificateChain(String encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * Set hostname verifier for SSL session.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder hostnameVerifier(javax.net.ssl.HostnameVerifier hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * Set hostname verifier for SSL session.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder hostnameVerifier(String hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * The access token that is used by the server when it sends an async
         * MDN.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnAccessToken the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder mdnAccessToken(String mdnAccessToken) {
            doSetProperty("mdnAccessToken", mdnAccessToken);
            return this;
        }
        /**
         * The password that is used by the server for basic authentication when
         * it sends an async MDN.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnPassword the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder mdnPassword(String mdnPassword) {
            doSetProperty("mdnPassword", mdnPassword);
            return this;
        }
        /**
         * The user-name that is used by the server for basic authentication
         * when it sends an async MDN. If options for basic authentication and
         * bearer authentication are both set then basic authentication takes
         * precedence.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param mdnUserName the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder mdnUserName(String mdnUserName) {
            doSetProperty("mdnUserName", mdnUserName);
            return this;
        }
        /**
         * The password that is used by the client for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message disposition
         * notification (MDN). Multiple algorithms can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signedReceiptMicAlgorithms(String signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.as2.api.AS2SignatureAlgorithm</code>
         * type.
         * 
         * Group: security
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingAlgorithm(org.apache.camel.component.as2.api.AS2SignatureAlgorithm signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.as2.api.AS2SignatureAlgorithm</code>
         * type.
         * 
         * Group: security
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingAlgorithm(String signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingCertificateChain(java.security.cert.Certificate[] signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingCertificateChain(String signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option is a: <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingPrivateKey(java.security.PrivateKey signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option will be converted to a
         * <code>java.security.PrivateKey</code> type.
         * 
         * Group: security
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingPrivateKey(String signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * Set SSL context for connection to remote server.
         * 
         * The option is a: <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder sslContext(javax.net.ssl.SSLContext sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * Set SSL context for connection to remote server.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * The user-name that is used by the client for basic authentication. If
         * options for basic authentication and bearer authentication are both
         * set then basic authentication takes precedence.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Certificates to validate the message's signature against. If not
         * supplied, validation will not take place. Server: validates the
         * received message. Client: not yet implemented, should validate the
         * MDN.
         * 
         * The option is a: <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param validateSigningCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder validateSigningCertificateChain(java.security.cert.Certificate[] validateSigningCertificateChain) {
            doSetProperty("validateSigningCertificateChain", validateSigningCertificateChain);
            return this;
        }
        /**
         * Certificates to validate the message's signature against. If not
         * supplied, validation will not take place. Server: validates the
         * received message. Client: not yet implemented, should validate the
         * MDN.
         * 
         * The option will be converted to a
         * <code>java.security.cert.Certificate[]</code> type.
         * 
         * Group: security
         * 
         * @param validateSigningCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder validateSigningCertificateChain(String validateSigningCertificateChain) {
            doSetProperty("validateSigningCertificateChain", validateSigningCertificateChain);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AS2 component.
     */
    public interface AdvancedAS2EndpointBuilder
            extends
                AdvancedAS2EndpointConsumerBuilder,
                AdvancedAS2EndpointProducerBuilder {
        default AS2EndpointBuilder basic() {
            return (AS2EndpointBuilder) this;
        }

    }

    public interface AS2Builders {
        /**
         * AS2 (camel-as2)
         * Transfer data securely and reliably using the AS2 protocol (RFC4130).
         * 
         * Category: file
         * Since: 2.22
         * Maven coordinates: org.apache.camel:camel-as2
         * 
         * Syntax: <code>as2:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 3 enums and the value can be one of: CLIENT, SERVER,
         * RECEIPT
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2(String path) {
            return AS2EndpointBuilderFactory.endpointBuilder("as2", path);
        }
        /**
         * AS2 (camel-as2)
         * Transfer data securely and reliably using the AS2 protocol (RFC4130).
         * 
         * Category: file
         * Since: 2.22
         * Maven coordinates: org.apache.camel:camel-as2
         * 
         * Syntax: <code>as2:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 3 enums and the value can be one of: CLIENT, SERVER,
         * RECEIPT
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2(String componentName, String path) {
            return AS2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    static AS2EndpointBuilder endpointBuilder(String componentName, String path) {
        class AS2EndpointBuilderImpl extends AbstractEndpointBuilder implements AS2EndpointBuilder, AdvancedAS2EndpointBuilder {
            public AS2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AS2EndpointBuilderImpl(path);
    }
}