/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ElseNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ThenNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TrimmingColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;
import org.apache.cayenne.access.translator.select.BaseSQLTreeProcessor;

public class HSQLTreeProcessor
extends BaseSQLTreeProcessor {
    @Override
    protected void onValueNode(Node parent, ValueNode child, int index) {
        boolean needBinding = !(parent instanceof ThenNode) && !(parent instanceof ElseNode);
        HSQLTreeProcessor.replaceChild(parent, index, new ValueNode(child.getValue(), child.isArray(), child.getAttribute(), needBinding));
    }

    @Override
    protected void onColumnNode(Node parent, ColumnNode child, int index) {
        HSQLTreeProcessor.replaceChild(parent, index, new TrimmingColumnNode(child));
    }

    @Override
    protected void onFunctionNode(Node parent, FunctionNode child, int index) {
        Node replacement = this.getReplacementForFunction(child);
        if (replacement != null) {
            HSQLTreeProcessor.replaceChild(parent, index, replacement);
        }
    }

    private Node getReplacementForFunction(FunctionNode child) {
        switch (child.getFunctionName()) {
            case "DAY_OF_MONTH": 
            case "DAY_OF_WEEK": 
            case "DAY_OF_YEAR": {
                return new FunctionNode(child.getFunctionName().replace("_", ""), child.getAlias(), true);
            }
            case "CURRENT_DATE": 
            case "CURRENT_TIMESTAMP": {
                return new FunctionNode(child.getFunctionName(), child.getAlias(), false);
            }
            case "CURRENT_TIME": {
                return new FunctionNode("LOCALTIME", child.getAlias(), false);
            }
            case "CONCAT": {
                return new OpExpressionNode("||");
            }
        }
        return null;
    }
}

