/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.path;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.exp.path.MultiSegmentCayennePath;

class SingleSegmentCayennePath
implements CayennePath,
Serializable {
    private final CayennePathSegment segment;
    private final int marker;

    SingleSegmentCayennePath(CayennePathSegment segment, int marker) {
        this.segment = Objects.requireNonNull(segment, "Segment can't be null");
        this.marker = marker;
    }

    @Override
    public CayennePath dot(CayennePathSegment next) {
        return new MultiSegmentCayennePath(List.of(this.segment, next), this.marker);
    }

    @Override
    public List<CayennePathSegment> segments() {
        return List.of(this.segment);
    }

    @Override
    public int marker() {
        return this.marker;
    }

    @Override
    public CayennePath parent() {
        return EMPTY_PATH;
    }

    @Override
    public CayennePathSegment last() {
        return this.segment;
    }

    @Override
    public CayennePathSegment first() {
        return this.segment;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CayennePath)) {
            return false;
        }
        CayennePath that = (CayennePath)o;
        if (that.length() != 1) {
            return false;
        }
        return that.marker() == this.marker && this.segment.equals(that.segments().get(0));
    }

    public int hashCode() {
        return 31 * this.marker + this.segment.hashCode();
    }

    @Override
    public String toString() {
        return this.segment.toString();
    }

    @Override
    public Iterator<CayennePathSegment> iterator() {
        return new PathIterator();
    }

    class PathIterator
    implements Iterator<CayennePathSegment> {
        boolean advanced;

        PathIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.advanced;
        }

        @Override
        public CayennePathSegment next() {
            if (this.advanced) {
                throw new NoSuchElementException();
            }
            this.advanced = true;
            return SingleSegmentCayennePath.this.segment;
        }

        @Override
        public void forEachRemaining(Consumer<? super CayennePathSegment> action) {
            Objects.requireNonNull(action);
            if (!this.advanced) {
                action.accept(SingleSegmentCayennePath.this.segment);
                this.advanced = true;
            }
        }
    }
}

