/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.editor.cgen.CgenConfigPanel;
import org.apache.cayenne.modeler.editor.cgen.CgenController;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.TemplateEditorController;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;

public class CgenConfigController
extends CayenneController {
    private CgenConfiguration cgenConfiguration;
    protected CgenConfigPanel view;
    protected DataMapDefaults preferences;
    protected CgenController cgenController;
    private boolean isEditorOpen;
    private static final String EDITED = " (edited)";

    public CgenConfigController(CgenController parent) {
        super(parent);
        this.cgenController = parent;
        this.view = new CgenConfigPanel(this.getParentController());
        this.isEditorOpen = false;
        this.initListeners();
        this.initBindings(new BindingBuilder(this.getApplication().getBindingFactory(), this));
    }

    protected void initListeners() {
        this.view.getPairs().addActionListener(val -> {
            this.cgenConfiguration.setMakePairs(this.view.getPairs().isSelected());
            if (!this.view.getPairs().isSelected()) {
                this.setSingleclassForDefaults();
            } else {
                this.setSubclassForDefaults();
            }
            this.updateTemplateEditorButtons();
            this.initForm(this.cgenConfiguration);
            this.getParentController().checkCgenConfigDirty();
        });
        this.view.getOverwrite().addActionListener(val -> {
            this.cgenConfiguration.setOverwrite(this.view.getOverwrite().isSelected());
            this.getParentController().checkCgenConfigDirty();
        });
        this.view.getCreatePropertyNames().addActionListener(val -> {
            this.cgenConfiguration.setCreatePropertyNames(this.view.getCreatePropertyNames().isSelected());
            this.getParentController().checkCgenConfigDirty();
        });
        this.view.getUsePackagePath().addActionListener(val -> {
            this.cgenConfiguration.setUsePkgPath(this.view.getUsePackagePath().isSelected());
            this.getParentController().checkCgenConfigDirty();
        });
        this.view.getPkProperties().addActionListener(val -> {
            this.cgenConfiguration.setCreatePKProperties(this.view.getPkProperties().isSelected());
            this.getParentController().checkCgenConfigDirty();
        });
        this.view.getEditSubclassTemplateBtn().addActionListener(val -> new TemplateEditorController(this, TemplateType.ENTITY_SUBCLASS).startupAction());
        this.view.getEditSuperclassTemplateBtn().addActionListener(val -> new TemplateEditorController(this, TemplateType.ENTITY_SUPERCLASS).startupAction());
        this.view.getEditEmbeddableTemplateBtn().addActionListener(val -> new TemplateEditorController(this, TemplateType.EMBEDDABLE_SUBCLASS).startupAction());
        this.view.getEditEmbeddableSuperTemplateBtn().addActionListener(val -> new TemplateEditorController(this, TemplateType.EMBEDDABLE_SUPERCLASS).startupAction());
        this.view.getEditDataMapTemplateBtn().addActionListener(val -> new TemplateEditorController(this, TemplateType.DATAMAP_SUBCLASS).startupAction());
        this.view.getEditDataMapSuperTemplateBtn().addActionListener(val -> new TemplateEditorController(this, TemplateType.DATAMAP_SUPERCLASS).startupAction());
    }

    private void initBindings(BindingBuilder bindingBuilder) {
        JButton outputSelect = this.getView().getSelectOutputFolder();
        bindingBuilder.bindToAction(outputSelect, "selectOutputFolderAction()");
    }

    protected CgenController getParentController() {
        return (CgenController)this.getParent();
    }

    private void setSubclassForDefaults() {
        if (TemplateType.isDefault(this.cgenConfiguration.getTemplate().getData())) {
            this.cgenConfiguration.setTemplate(TemplateType.ENTITY_SUBCLASS.defaultTemplate());
        }
        if (TemplateType.isDefault(this.cgenConfiguration.getEmbeddableTemplate().getData())) {
            this.cgenConfiguration.setEmbeddableTemplate(TemplateType.EMBEDDABLE_SUBCLASS.defaultTemplate());
        }
        if (TemplateType.isDefault(this.cgenConfiguration.getDataMapTemplate().getData())) {
            this.cgenConfiguration.setDataMapTemplate(TemplateType.DATAMAP_SUBCLASS.defaultTemplate());
        }
    }

    private void setSingleclassForDefaults() {
        if (TemplateType.isDefault(this.cgenConfiguration.getTemplate().getData())) {
            this.cgenConfiguration.setTemplate(TemplateType.ENTITY_SINGLE_CLASS.defaultTemplate());
        }
        if (TemplateType.isDefault(this.cgenConfiguration.getEmbeddableTemplate().getData())) {
            this.cgenConfiguration.setEmbeddableTemplate(TemplateType.EMBEDDABLE_SINGLE_CLASS.defaultTemplate());
        }
        if (TemplateType.isDefault(this.cgenConfiguration.getDataMapTemplate().getData())) {
            this.cgenConfiguration.setDataMapTemplate(TemplateType.DATAMAP_SINGLE_CLASS.defaultTemplate());
        }
    }

    @Override
    public CgenConfigPanel getView() {
        return this.view;
    }

    public void initForm(CgenConfiguration cgenConfiguration) {
        this.cgenConfiguration = cgenConfiguration;
        if (cgenConfiguration.getRootPath() != null) {
            this.getView().getOutputFolder().setText(cgenConfiguration.buildOutputPath().toString());
        }
        if (cgenConfiguration.getArtifactsGenerationMode().equalsIgnoreCase("all")) {
            this.getParentController().setCurrentClass(cgenConfiguration.getDataMap());
            this.getParentController().setSelected(true);
        }
        this.getView().getOutputFolder().updateModel();
        this.view.getOutputPattern().setText(cgenConfiguration.getOutputPattern());
        this.view.getPairs().setSelected(cgenConfiguration.isMakePairs());
        this.view.getUsePackagePath().setSelected(cgenConfiguration.isUsePkgPath());
        this.view.getOverwrite().setSelected(cgenConfiguration.isOverwrite());
        this.view.getCreatePropertyNames().setSelected(cgenConfiguration.isCreatePropertyNames());
        this.view.getPkProperties().setSelected(cgenConfiguration.isCreatePKProperties());
        this.view.getSuperPkg().setText(cgenConfiguration.getSuperPkg());
        this.updateTemplatesLabels(cgenConfiguration);
    }

    public void updateTemplatesLabels(CgenConfiguration configuration) {
        this.updateTemplateLabel(this.view.getEntityTemplateLbl(), TemplateType.ENTITY_SUBCLASS, configuration.getTemplate().getData());
        this.updateTemplateLabel(this.view.getEntitySuperTemplateLbl(), TemplateType.ENTITY_SUPERCLASS, configuration.getSuperTemplate().getData());
        this.updateTemplateLabel(this.view.getEmbeddableTemplateLbl(), TemplateType.EMBEDDABLE_SUBCLASS, configuration.getEmbeddableTemplate().getData());
        this.updateTemplateLabel(this.view.getEmbeddableSuperTemplateLbl(), TemplateType.EMBEDDABLE_SUPERCLASS, configuration.getEmbeddableSuperTemplate().getData());
        this.updateTemplateLabel(this.view.getDatamapTemplateLbl(), TemplateType.DATAMAP_SUBCLASS, configuration.getDataMapTemplate().getData());
        this.updateTemplateLabel(this.view.getDatamapSuperTemplateLbl(), TemplateType.DATAMAP_SUPERCLASS, configuration.getDataMapSuperTemplate().getData());
    }

    private void updateTemplateLabel(JLabel label, TemplateType type, String template) {
        if (!TemplateType.isDefault(template)) {
            label.setText(type.readableName() + EDITED);
        } else {
            label.setText(type.readableName());
        }
    }

    public void updateTemplateEditorButtons() {
        boolean isMakePairs = this.view.getPairs().isSelected();
        boolean isEntitiesSelected = this.getParentController().isEntitiesSelected();
        boolean isEmbeddableSelected = this.getParentController().isEmbeddableSelected();
        boolean isDataMapSelected = this.getParentController().isDataMapSelected();
        this.view.getEditSubclassTemplateBtn().setEnabled(isEntitiesSelected && !this.isEditorOpen);
        this.view.getEditSuperclassTemplateBtn().setEnabled(isMakePairs && isEntitiesSelected && !this.isEditorOpen);
        this.view.getEditEmbeddableTemplateBtn().setEnabled(isEmbeddableSelected && !this.isEditorOpen);
        this.view.getEditEmbeddableSuperTemplateBtn().setEnabled(isMakePairs && isEmbeddableSelected && !this.isEditorOpen);
        this.view.getEditDataMapTemplateBtn().setEnabled(isDataMapSelected && !this.isEditorOpen);
        this.view.getEditDataMapSuperTemplateBtn().setEnabled(isMakePairs && isDataMapSelected && !this.isEditorOpen);
        this.setToolTipText(this.view.getEditSubclassTemplateBtn());
        this.setToolTipText(this.view.getEditSuperclassTemplateBtn());
        this.setToolTipText(this.view.getEditEmbeddableTemplateBtn());
        this.setToolTipText(this.view.getEditEmbeddableSuperTemplateBtn());
        this.setToolTipText(this.view.getEditDataMapTemplateBtn());
        this.setToolTipText(this.view.getEditDataMapSuperTemplateBtn());
    }

    private void setToolTipText(JButton button) {
        if (button.isEnabled()) {
            button.setToolTipText("Open template editor");
        } else {
            button.setToolTipText("At least one artefact of appropriate type must be selected. The Make Pairs checkbox can also affect the blocking");
        }
    }

    public void selectOutputFolderAction() {
        TextAdapter outputFolder = this.getView().getOutputFolder();
        String currentDir = outputFolder.getComponent().getText();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(0);
        if (!Util.isEmptyString(currentDir)) {
            chooser.setCurrentDirectory(new File(currentDir));
        } else {
            FSPath lastDir = Application.getInstance().getFrameController().getLastDirectory();
            lastDir.updateChooser(chooser);
        }
        int result = chooser.showOpenDialog(this.getView());
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            String path = selected.getAbsolutePath();
            this.getView().getOutputFolder().setText(path);
            this.getView().getOutputFolder().updateModel();
        }
    }

    public CgenController getCodeGeneratorController() {
        return this.cgenController;
    }

    public void setEditorOpen(boolean editorOpen) {
        this.isEditorOpen = editorOpen;
    }
}

