/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.DefaultQueryMetadata;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.Util;

public class ObjectIdQuery
extends IndirectQuery {
    public static final int CACHE = 1;
    public static final int CACHE_REFRESH = 2;
    public static final int CACHE_NOREFRESH = 3;
    protected ObjectId objectId;
    protected int cachePolicy;
    protected boolean fetchingDataRows;
    protected transient EntityResolver metadataResolver;
    protected transient QueryMetadata metadata;

    private ObjectIdQuery() {
        this.cachePolicy = 2;
    }

    public ObjectIdQuery(ObjectId objectID) {
        this(objectID, false, 2);
    }

    public ObjectIdQuery(ObjectId objectId, boolean fetchingDataRows, int cachePolicy) {
        if (objectId == null) {
            throw new NullPointerException("Null objectID");
        }
        this.objectId = objectId;
        this.cachePolicy = cachePolicy;
        this.fetchingDataRows = fetchingDataRows;
    }

    @Override
    public QueryMetadata getMetaData(final EntityResolver resolver) {
        if (this.metadata == null || this.metadataResolver != resolver) {
            this.metadata = new DefaultQueryMetadata(){

                @Override
                public ClassDescriptor getClassDescriptor() {
                    return resolver.getClassDescriptor(ObjectIdQuery.this.objectId.getEntityName());
                }

                @Override
                public ObjEntity getObjEntity() {
                    return this.getClassDescriptor().getEntity();
                }

                @Override
                public boolean isFetchingDataRows() {
                    return ObjectIdQuery.this.fetchingDataRows;
                }
            };
            this.metadataResolver = resolver;
        }
        return this.metadata;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        if (this.objectId == null) {
            throw new CayenneRuntimeException("Can't resolve query - objectId is null.", new Object[0]);
        }
        if (this.objectId.isTemporary() && !this.objectId.isReplacementIdAttached()) {
            throw new CayenneRuntimeException("Can't build a query for temporary id: %s", this.objectId);
        }
        ObjectSelect query = (ObjectSelect)((ObjectSelect)ObjectSelect.query(Persistent.class).entityName(this.objectId.getEntityName())).where(ExpressionFactory.matchAllDbExp(this.objectId.getIdSnapshot(), 3));
        if (this.fetchingDataRows) {
            query.fetchDataRows();
        }
        return query;
    }

    public int getCachePolicy() {
        return this.cachePolicy;
    }

    public boolean isFetchMandatory() {
        return this.cachePolicy == 2;
    }

    public boolean isFetchAllowed() {
        return this.cachePolicy != 3;
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }

    public String toString() {
        return Util.stripPackageName(this.getClass().getName()) + ":" + this.objectId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectIdQuery)) {
            return false;
        }
        ObjectIdQuery query = (ObjectIdQuery)object;
        return Util.nullSafeEquals(this.objectId, query.getObjectId());
    }

    public int hashCode() {
        return this.objectId != null ? this.objectId.hashCode() : 11;
    }
}

