/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.path;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.cayenne.exp.path.CayennePathSegment;

class SegmentList
extends AbstractList<CayennePathSegment>
implements RandomAccess,
Serializable {
    final CayennePathSegment[] segments;
    final int fromIdx;
    final int toIdx;

    SegmentList(CayennePathSegment[] data, int fromIdx, int toIdx) {
        this.segments = Objects.requireNonNull(data);
        this.fromIdx = fromIdx;
        this.toIdx = toIdx;
        if (toIdx > data.length || fromIdx > toIdx) {
            throw new IndexOutOfBoundsException(toIdx);
        }
    }

    @Override
    public CayennePathSegment get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.segments[index + this.fromIdx];
    }

    @Override
    public int size() {
        return this.toIdx - this.fromIdx;
    }

    @Override
    public List<CayennePathSegment> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        return new SegmentList(this.segments, this.fromIdx + fromIndex, this.fromIdx + toIndex);
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] copy = new Object[size];
        System.arraycopy(this.segments, this.fromIdx, copy, 0, size);
        return copy;
    }
}

