/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.StaticBucketMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StaticBucketMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    @Override
    public boolean isFailFastExpected() {
        return false;
    }

    @Override
    public StaticBucketMap<K, V> makeObject() {
        return new StaticBucketMap(30);
    }

    @Test
    public void test_containsKey_nullMatchesIncorrectly() {
        StaticBucketMap map = new StaticBucketMap(17);
        map.put(null, (Object)"A");
        Assertions.assertTrue((boolean)map.containsKey(null));
        for (int i = 65; i <= 90; ++i) {
            String str = String.valueOf((char)i);
            Assertions.assertFalse((boolean)map.containsKey((Object)str), (String)("String: " + str));
        }
    }

    @Test
    public void test_containsValue_nullMatchesIncorrectly() {
        StaticBucketMap map = new StaticBucketMap(17);
        map.put((Object)"A", null);
        Assertions.assertTrue((boolean)map.containsValue(null));
        for (int i = 65; i <= 90; ++i) {
            String str = String.valueOf((char)i);
            Assertions.assertFalse((boolean)map.containsValue((Object)str), (String)("String: " + str));
        }
    }

    @Test
    public void test_get_nullMatchesIncorrectly() {
        StaticBucketMap map = new StaticBucketMap(17);
        map.put(null, (Object)"A");
        Assertions.assertEquals((Object)"A", (Object)map.get(null));
        for (int i = 65; i <= 90; ++i) {
            String str = String.valueOf((char)i);
            Assertions.assertNull((Object)map.get((Object)str), (String)("String: " + str));
        }
    }
}

