/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.set.AbstractNavigableSetTest;
import org.apache.commons.collections4.set.TransformedNavigableSet;
import org.apache.commons.collections4.set.TransformedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedNavigableSetTest<E>
extends AbstractNavigableSetTest<E> {
    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }

    @Override
    public NavigableSet<E> makeFullCollection() {
        TreeSet set = new TreeSet(Arrays.asList(this.getFullElements()));
        return TransformedNavigableSet.transformingNavigableSet(set, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public NavigableSet<E> makeObject() {
        return TransformedNavigableSet.transformingNavigableSet(new TreeSet(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Test
    public void testTransformedSet() {
        TransformedNavigableSet set = TransformedNavigableSet.transformingNavigableSet(new TreeSet(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)set.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            set.add(els[i]);
            Assertions.assertEquals((int)(i + 1), (int)set.size());
            Assertions.assertTrue((boolean)set.contains(Integer.valueOf((String)els[i])));
        }
        Assertions.assertTrue((boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    @Test
    public void testTransformedSet_decorateTransform() {
        TreeSet originalSet = new TreeSet();
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalSet, els);
        Set set = TransformedSet.transformedSet(originalSet, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)els.length, (int)set.size());
        for (Object el : els) {
            Assertions.assertTrue((boolean)set.contains(Integer.valueOf((String)el)));
        }
        Assertions.assertTrue((boolean)set.remove(Integer.valueOf((String)els[0])));
    }
}

