/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamCompressorTest {
    StreamCompressorTest() {
    }

    @Test
    void testCreateDataOutputCompressor() throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new ByteArrayOutputStream());
        try (StreamCompressor streamCompressor = StreamCompressor.create((DataOutput)dataOutputStream, (Deflater)new Deflater(9));){
            Assertions.assertNotNull((Object)streamCompressor);
        }
    }

    @Test
    void testDeflatedEntries() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (StreamCompressor sc = StreamCompressor.create((OutputStream)baos);){
            sc.deflate((InputStream)new ByteArrayInputStream("AAAAAABBBBBB".getBytes()), 8);
            Assertions.assertEquals((long)12L, (long)sc.getBytesRead());
            Assertions.assertEquals((long)8L, (long)sc.getBytesWrittenForLastEntry());
            Assertions.assertEquals((long)3299542L, (long)sc.getCrc32());
            byte[] actuals = baos.toByteArray();
            byte[] expected = new byte[]{115, 116, 4, 1, 39, 48, 0, 0};
            Assertions.assertArrayEquals((byte[])expected, (byte[])actuals);
        }
    }

    @Test
    void testStoredEntries() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (StreamCompressor sc = StreamCompressor.create((OutputStream)baos);){
            sc.deflate((InputStream)new ByteArrayInputStream("A".getBytes()), 0);
            sc.deflate((InputStream)new ByteArrayInputStream("BAD".getBytes()), 0);
            Assertions.assertEquals((long)3L, (long)sc.getBytesRead());
            Assertions.assertEquals((long)3L, (long)sc.getBytesWrittenForLastEntry());
            Assertions.assertEquals((long)344750961L, (long)sc.getCrc32());
            sc.deflate((InputStream)new ByteArrayInputStream("CAFE".getBytes()), 0);
            Assertions.assertEquals((Object)"ABADCAFE", (Object)baos.toString());
        }
    }
}

