/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BlockLZ4CompressorInputStreamTest
extends AbstractTest {
    BlockLZ4CompressorInputStreamTest() {
    }

    @Test
    void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BlockLZ4CompressorInputStream in = new BlockLZ4CompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    void testReadBlaLz4() throws IOException {
        try (BlockLZ4CompressorInputStream a = new BlockLZ4CompressorInputStream(BlockLZ4CompressorInputStreamTest.newInputStream("bla.tar.block_lz4"));
             InputStream e = BlockLZ4CompressorInputStreamTest.newInputStream("bla.tar");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BlockLZ4CompressorInputStream in = new BlockLZ4CompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }
}

