/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode;

import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPClass;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPMember;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ConstantPoolTest {
    private ClassConstantPool pool;

    ConstantPoolTest() {
    }

    @BeforeEach
    public void setUp() {
        this.pool = new ClassConstantPool();
    }

    @Test
    void testDuplicateField() {
        CPMember cp1 = new CPMember(new CPUTF8("name", 1), new CPUTF8("I", 2), 0L, null);
        this.pool.add((ClassFileEntry)cp1);
        this.pool.addNestedEntries();
        Assertions.assertEquals((int)2, (int)this.pool.size());
        CPMember cp2 = new CPMember(new CPUTF8("name", 1), new CPUTF8("I", 2), 0L, null);
        this.pool.add((ClassFileEntry)cp2);
        this.pool.addNestedEntries();
        Assertions.assertEquals((int)2, (int)this.pool.size());
    }

    @Test
    void testDuplicateUTF8() {
        CPUTF8 u1 = new CPUTF8("thing", 1);
        CPUTF8 u2 = new CPUTF8("thing", 1);
        this.pool.add((ClassFileEntry)u1);
        this.pool.add((ClassFileEntry)u2);
        Assertions.assertEquals((int)1, (int)this.pool.size());
    }

    @Test
    void testEntries() {
        this.pool.add((ClassFileEntry)new CPClass(new CPUTF8("RandomClass", 1), 10));
        this.pool.add((ClassFileEntry)new CPClass(new CPUTF8("RandomClass2", 2), 20));
        Assertions.assertEquals((int)2, (int)this.pool.entries().size());
    }

    @Test
    void testIndex() {
        this.pool.add((ClassFileEntry)new CPUTF8("OtherThing", 1));
        CPUTF8 u1 = new CPUTF8("thing", 2);
        this.pool.add((ClassFileEntry)u1);
        this.pool.resolve(new Segment());
        Assertions.assertTrue((this.pool.indexOf((ClassFileEntry)u1) > 0 ? 1 : 0) != 0);
    }
}

