/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import com.mockobjects.dynamic.Mock;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junitx.framework.ListAssert;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.NonCloneableConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationUtils {
    protected Configuration config = new BaseConfiguration();

    @Test
    public void testToString() {
        String lineSeparator = System.getProperty("line.separator");
        Assert.assertEquals((String)"String representation of an empty configuration", (Object)"", (Object)ConfigurationUtils.toString((Configuration)this.config));
        this.config.setProperty("one", (Object)"1");
        Assert.assertEquals((String)"String representation of a configuration", (Object)"one=1", (Object)ConfigurationUtils.toString((Configuration)this.config));
        this.config.setProperty("two", (Object)"2");
        Assert.assertEquals((String)"String representation of a configuration", (Object)("one=1" + lineSeparator + "two=2"), (Object)ConfigurationUtils.toString((Configuration)this.config));
        this.config.clearProperty("one");
        Assert.assertEquals((String)"String representation of a configuration", (Object)"two=2", (Object)ConfigurationUtils.toString((Configuration)this.config));
        this.config.setProperty("one", (Object)"1");
        Assert.assertEquals((String)"String representation of a configuration", (Object)("two=2" + lineSeparator + "one=1"), (Object)ConfigurationUtils.toString((Configuration)this.config));
    }

    @Test
    public void testGetURL() throws Exception {
        Assert.assertEquals((Object)"http://localhost:8080/webapp/config/config.xml", (Object)ConfigurationUtils.getURL((String)"http://localhost:8080/webapp/config/baseConfig.xml", (String)"config.xml").toString());
        Assert.assertEquals((Object)"http://localhost:8080/webapp/config/config.xml", (Object)ConfigurationUtils.getURL((String)"http://localhost:8080/webapp/baseConfig.xml", (String)"config/config.xml").toString());
        URL url = ConfigurationUtils.getURL(null, (String)"config.xml");
        Assert.assertEquals((Object)"file", (Object)url.getProtocol());
        Assert.assertEquals((Object)"", (Object)url.getHost());
        Assert.assertEquals((Object)"http://localhost:8080/webapp/config/config.xml", (Object)ConfigurationUtils.getURL((String)"ftp://ftp.server.com/downloads/baseConfig.xml", (String)"http://localhost:8080/webapp/config/config.xml").toString());
        Assert.assertEquals((Object)"http://localhost:8080/webapp/config/config.xml", (Object)ConfigurationUtils.getURL(null, (String)"http://localhost:8080/webapp/config/config.xml").toString());
        File absFile = new File("config.xml").getAbsoluteFile();
        Assert.assertEquals((Object)absFile.toURI().toURL(), (Object)ConfigurationUtils.getURL((String)"http://localhost:8080/webapp/config/baseConfig.xml", (String)absFile.getAbsolutePath()));
        Assert.assertEquals((Object)absFile.toURI().toURL(), (Object)ConfigurationUtils.getURL(null, (String)absFile.getAbsolutePath()));
        Assert.assertEquals((Object)absFile.toURI().toURL(), (Object)ConfigurationUtils.getURL((String)absFile.getParent(), (String)"config.xml"));
    }

    @Test
    public void testGetBasePath() throws Exception {
        URL url = new URL("http://xyz.net/foo/bar.xml");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/foo/", (Object)ConfigurationUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/foo/");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/foo/", (Object)ConfigurationUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/foo");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/", (Object)ConfigurationUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/", (Object)ConfigurationUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net", (Object)ConfigurationUtils.getBasePath((URL)url));
    }

    @Test
    public void testGetFileName() throws Exception {
        Assert.assertEquals((String)"file name for a null URL", null, (Object)ConfigurationUtils.getFileName(null));
        URL url = new URL("http://xyz.net/foo/");
        Assert.assertEquals((String)("file for a directory URL " + url), null, (Object)ConfigurationUtils.getFileName((URL)url));
        url = new URL("http://xyz.net/foo/bar.xml");
        Assert.assertEquals((String)("file name for a valid URL " + url), (Object)"bar.xml", (Object)ConfigurationUtils.getFileName((URL)url));
    }

    @Test
    public void testCopy() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("key1", (Object)"value1");
        conf1.addProperty("key2", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("key1", (Object)"value3");
        conf2.addProperty("key2", (Object)"value4");
        ConfigurationUtils.copy((Configuration)conf1, (Configuration)conf2);
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf2.getProperty("key1"));
        Assert.assertEquals((String)"'key2' property", (Object)"value2", (Object)conf2.getProperty("key2"));
    }

    @Test
    public void testAppend() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("key1", (Object)"value1");
        conf1.addProperty("key2", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("key1", (Object)"value3");
        conf2.addProperty("key2", (Object)"value4");
        ConfigurationUtils.append((Configuration)conf1, (Configuration)conf2);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("value3");
        expected.add("value1");
        ListAssert.assertEquals((String)"'key1' property", expected, (List)conf2.getList("key1"));
        expected = new ArrayList();
        expected.add("value4");
        expected.add("value2");
        ListAssert.assertEquals((String)"'key2' property", expected, (List)conf2.getList("key2"));
    }

    @Test
    public void testGetFile() throws Exception {
        File directory = new File("target");
        File reference = new File(directory, "test.txt").getAbsoluteFile();
        Assert.assertEquals((Object)reference, (Object)ConfigurationUtils.getFile(null, (String)reference.getAbsolutePath()));
        Assert.assertEquals((Object)reference, (Object)ConfigurationUtils.getFile((String)directory.getAbsolutePath(), (String)reference.getAbsolutePath()));
        Assert.assertEquals((Object)reference, (Object)ConfigurationUtils.getFile((String)directory.getAbsolutePath(), (String)reference.getName()));
        Assert.assertEquals((Object)reference, (Object)ConfigurationUtils.getFile((String)directory.toURI().toURL().toString(), (String)reference.getName()));
        Assert.assertEquals((Object)reference, (Object)ConfigurationUtils.getFile((String)"invalid", (String)reference.toURI().toURL().toString()));
        Assert.assertEquals((Object)reference, (Object)ConfigurationUtils.getFile((String)"jar:file:/C:/myjar.jar!/my-config.xml/someprops.properties", (String)reference.getAbsolutePath()));
    }

    @Test
    public void testFileFromURLWithPlus() throws MalformedURLException {
        File file = new File(new File("target"), "foo+bar.txt").getAbsoluteFile();
        URL fileURL = file.toURI().toURL();
        File file2 = ConfigurationUtils.fileFromURL((URL)fileURL);
        Assert.assertEquals((String)"Wrong file", (Object)file, (Object)file2);
    }

    @Test
    public void testFileFromURLNull() throws Exception {
        Assert.assertNull((String)"Wrong file for null URL", (Object)ConfigurationUtils.fileFromURL(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocateWithNullTCCL() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            Assert.assertNull((Object)ConfigurationUtils.locate((String)"abase", (String)"aname"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Test
    public void testConvertToHierarchical() {
        BaseConfiguration conf = new BaseConfiguration();
        for (int i = 0; i < 10; ++i) {
            conf.addProperty("test" + i, (Object)("value" + i));
            conf.addProperty("test.list", (Object)("item" + i));
        }
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)conf);
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertEquals((String)("Wrong value for key " + key), (Object)conf.getProperty(key), (Object)hc.getProperty(key));
        }
    }

    @Test
    public void testConvertHierarchicalToHierarchical() {
        HierarchicalConfiguration conf = new HierarchicalConfiguration();
        conf.addProperty("test", (Object)"yes");
        Assert.assertSame((String)"Wrong configuration returned", (Object)conf, (Object)ConfigurationUtils.convertToHierarchical((Configuration)conf));
    }

    @Test
    public void testConvertNullToHierarchical() {
        Assert.assertNull((String)"Wrong conversion result for null config", (Object)ConfigurationUtils.convertToHierarchical(null));
    }

    @Test
    public void testConvertToHierarchicalDelimiters() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty("test.key", (Object)"1\\,2\\,3");
        Assert.assertEquals((String)"Wrong property value", (Object)"1,2,3", (Object)conf.getString("test.key"));
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)conf);
        Assert.assertEquals((String)"Escaped list delimiters not correctly handled", (Object)"1,2,3", (Object)hc.getString("test.key"));
    }

    @Test
    public void testConvertToHierarchicalEngine() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty("test(a)", (Object)Boolean.TRUE);
        conf.addProperty("test(b)", (Object)Boolean.FALSE);
        DefaultExpressionEngine engine = new DefaultExpressionEngine();
        engine.setIndexStart("[");
        engine.setIndexEnd("]");
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)conf, (ExpressionEngine)engine);
        Assert.assertTrue((String)"Wrong value for test(a)", (boolean)hc.getBoolean("test(a)"));
        Assert.assertFalse((String)"Wrong value for test(b)", (boolean)hc.getBoolean("test(b)"));
    }

    @Test
    public void testConvertHierarchicalToHierarchicalEngine() {
        HierarchicalConfiguration hc = new HierarchicalConfiguration();
        DefaultExpressionEngine engine = new DefaultExpressionEngine();
        Assert.assertSame((String)"Created new configuration", (Object)hc, (Object)ConfigurationUtils.convertToHierarchical((Configuration)hc, (ExpressionEngine)engine));
        Assert.assertSame((String)"Engine was not set", (Object)engine, (Object)hc.getExpressionEngine());
    }

    @Test
    public void testConvertHierarchicalToHierarchicalNullEngine() {
        HierarchicalConfiguration hc = new HierarchicalConfiguration();
        DefaultExpressionEngine engine = new DefaultExpressionEngine();
        hc.setExpressionEngine((ExpressionEngine)engine);
        Assert.assertSame((String)"Created new configuration", (Object)hc, (Object)ConfigurationUtils.convertToHierarchical((Configuration)hc, null));
        Assert.assertSame((String)"Expression engine was changed", (Object)engine, (Object)hc.getExpressionEngine());
    }

    @Test
    public void testConvertToHierarchicalMultiValues() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("test", (Object)"1,2,3");
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)config);
        Assert.assertEquals((String)"Wrong value 1", (long)1L, (long)hc.getInt("test(0)"));
        Assert.assertEquals((String)"Wrong value 2", (long)2L, (long)hc.getInt("test(1)"));
        Assert.assertEquals((String)"Wrong value 3", (long)3L, (long)hc.getInt("test(2)"));
    }

    @Test
    public void testCloneConfiguration() {
        HierarchicalConfiguration conf = new HierarchicalConfiguration();
        conf.addProperty("test", (Object)"yes");
        HierarchicalConfiguration copy = (HierarchicalConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)conf);
        Assert.assertNotSame((String)"Same object was returned", (Object)conf, (Object)copy);
        Assert.assertEquals((String)"Property was not cloned", (Object)"yes", (Object)copy.getString("test"));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCloneConfigurationNotSupported() {
        NonCloneableConfiguration myNonCloneableConfig = new NonCloneableConfiguration();
        ConfigurationUtils.cloneConfiguration((Configuration)myNonCloneableConfig);
    }

    @Test
    public void testCloneConfigurationNull() {
        Assert.assertNull((String)"Wrong return value", (Object)ConfigurationUtils.cloneConfiguration(null));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testEnableRuntimeExceptions() {
        PropertiesConfiguration config = new PropertiesConfiguration(){

            protected void addPropertyDirect(String key, Object value) {
                this.fireError(1, key, value, new RuntimeException("A faked exception!"));
            }
        };
        config.clearErrorListeners();
        ConfigurationUtils.enableRuntimeExceptions((Configuration)config);
        config.addProperty("test", (Object)"testValue");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableRuntimeExceptionsInvalid() {
        ConfigurationUtils.enableRuntimeExceptions((Configuration)((Configuration)new Mock(Configuration.class).proxy()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableRuntimeExceptionsNull() {
        ConfigurationUtils.enableRuntimeExceptions(null);
    }
}

