/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.HierarchicalConfigurationXMLReader;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TestHierarchicalConfigurationXMLReader {
    private static final String TEST_FILE = ConfigurationAssert.getTestFile("testHierarchicalXMLConfiguration.xml").getAbsolutePath();
    private HierarchicalConfigurationXMLReader parser;

    @Before
    public void setUp() throws Exception {
        XMLConfiguration config = new XMLConfiguration();
        config.setFileName(TEST_FILE);
        config.load();
        this.parser = new HierarchicalConfigurationXMLReader((HierarchicalConfiguration)config);
    }

    @Test
    public void testParse() throws Exception {
        SAXSource source = new SAXSource((XMLReader)this.parser, new InputSource());
        DOMResult result = new DOMResult();
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(source, result);
        Element root = ((Document)result.getNode()).getDocumentElement();
        JXPathContext ctx = JXPathContext.newContext((Object)root);
        Assert.assertEquals((String)"Wrong name of root element", (Object)"database", (Object)root.getNodeName());
        Assert.assertEquals((String)"Wrong number of children of root", (long)1L, (long)ctx.selectNodes("/*").size());
        Assert.assertEquals((String)"Wrong number of tables", (long)2L, (long)ctx.selectNodes("/tables/table").size());
        Assert.assertEquals((String)"Wrong name of first table", (Object)"users", (Object)ctx.getValue("/tables/table[1]/name"));
        Assert.assertEquals((String)"Wrong number of fields in first table", (long)5L, (long)ctx.selectNodes("/tables/table[1]/fields/field").size());
        Assert.assertEquals((String)"Wrong attribute value", (Object)"system", (Object)ctx.getValue("/tables/table[1]/@tableType"));
    }
}

