/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.InterpolationTestHelper;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.junit.Assert;
import org.junit.Test;

public class TestSubsetConfiguration {
    static final String TEST_DIR = "target/test-classes";
    static final String TEST_FILE = "testDigesterConfiguration2.xml";

    @Test
    public void testGetProperty() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("test.key1", (Object)"value1");
        conf.setProperty("testing.key2", (Object)"value1");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        Assert.assertFalse((String)"the subset is empty", (boolean)subset.isEmpty());
        Assert.assertTrue((String)"'key1' not found in the subset", (boolean)subset.containsKey("key1"));
        Assert.assertFalse((String)"'ng.key2' found in the subset", (boolean)subset.containsKey("ng.key2"));
    }

    @Test
    public void testSetProperty() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        subset.setProperty("key1", (Object)"value1");
        Assert.assertEquals((String)"key1 in the subset configuration", (Object)"value1", (Object)subset.getProperty("key1"));
        Assert.assertEquals((String)"test.key1 in the parent configuration", (Object)"value1", (Object)conf.getProperty("test.key1"));
        conf.setProperty("test.key2", (Object)"value2");
        Assert.assertEquals((String)"test.key2 in the parent configuration", (Object)"value2", (Object)conf.getProperty("test.key2"));
        Assert.assertEquals((String)"key2 in the subset configuration", (Object)"value2", (Object)subset.getProperty("key2"));
    }

    @Test
    public void testGetParentKey() {
        SubsetConfiguration subset = new SubsetConfiguration(null, "prefix", ".");
        Assert.assertEquals((String)"parent key for \"key\"", (Object)"prefix.key", (Object)subset.getParentKey("key"));
        Assert.assertEquals((String)"parent key for \"\"", (Object)"prefix", (Object)subset.getParentKey(""));
        subset = new SubsetConfiguration(null, "prefix", null);
        Assert.assertEquals((String)"parent key for \"key\"", (Object)"prefixkey", (Object)subset.getParentKey("key"));
        Assert.assertEquals((String)"parent key for \"\"", (Object)"prefix", (Object)subset.getParentKey(""));
    }

    @Test
    public void testGetChildKey() {
        SubsetConfiguration subset = new SubsetConfiguration(null, "prefix", ".");
        Assert.assertEquals((String)"parent key for \"prefixkey\"", (Object)"key", (Object)subset.getChildKey("prefix.key"));
        Assert.assertEquals((String)"parent key for \"prefix\"", (Object)"", (Object)subset.getChildKey("prefix"));
        subset = new SubsetConfiguration(null, "prefix", null);
        Assert.assertEquals((String)"parent key for \"prefixkey\"", (Object)"key", (Object)subset.getChildKey("prefixkey"));
        Assert.assertEquals((String)"parent key for \"prefix\"", (Object)"", (Object)subset.getChildKey("prefix"));
    }

    @Test
    public void testGetKeys() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("test", (Object)"value0");
        conf.setProperty("test.key1", (Object)"value1");
        conf.setProperty("testing.key2", (Object)"value1");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        Iterator it = subset.getKeys();
        Assert.assertEquals((String)"1st key", (Object)"", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"key1", it.next());
        Assert.assertFalse((String)"too many elements", (boolean)it.hasNext());
    }

    @Test
    public void testGetKeysWithPrefix() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("test.abc", (Object)"value0");
        conf.setProperty("test.abc.key1", (Object)"value1");
        conf.setProperty("test.abcdef.key2", (Object)"value1");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        Iterator it = subset.getKeys("abc");
        Assert.assertEquals((String)"1st key", (Object)"abc", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"abc.key1", it.next());
        Assert.assertFalse((String)"too many elements", (boolean)it.hasNext());
    }

    @Test
    public void testGetList() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("test.abc", (Object)"value0,value1");
        conf.addProperty("test.abc", (Object)"value3");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        List list = subset.getList("abc", new ArrayList());
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testGetParent() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "prefix", ".");
        Assert.assertEquals((String)"parent", (Object)conf, (Object)subset.getParent());
    }

    @Test
    public void testGetPrefix() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "prefix", ".");
        Assert.assertEquals((String)"prefix", (Object)"prefix", (Object)subset.getPrefix());
    }

    @Test
    public void testSetPrefix() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, null, ".");
        subset.setPrefix("prefix");
        Assert.assertEquals((String)"prefix", (Object)"prefix", (Object)subset.getPrefix());
    }

    @Test
    public void testThrowExceptionOnMissing() {
        BaseConfiguration config = new BaseConfiguration();
        config.setThrowExceptionOnMissing(true);
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)config, "prefix");
        try {
            subset.getString("foo");
            Assert.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        config.setThrowExceptionOnMissing(false);
        Assert.assertNull((Object)subset.getString("foo"));
        subset.setThrowExceptionOnMissing(true);
        try {
            config.getString("foo");
            Assert.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testNested() throws Exception {
        ConfigurationFactory factory = new ConfigurationFactory();
        File src = new File(new File(TEST_DIR), TEST_FILE);
        factory.setConfigurationURL(src.toURL());
        Configuration config = factory.getConfiguration();
        Configuration subConf = config.subset("tables.table(0)");
        Assert.assertTrue((boolean)subConf.getKeys().hasNext());
        Configuration subSubConf = subConf.subset("fields.field(1)");
        Iterator itKeys = subSubConf.getKeys();
        HashSet<String> keys = new HashSet<String>();
        keys.add("name");
        keys.add("type");
        while (itKeys.hasNext()) {
            String k = (String)itKeys.next();
            Assert.assertTrue((boolean)keys.contains(k));
            keys.remove(k);
        }
        Assert.assertTrue((boolean)keys.isEmpty());
    }

    @Test
    public void testClear() {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("test.key1", (Object)"value1");
        config.setProperty("testing.key2", (Object)"value1");
        Configuration subset = config.subset("test");
        subset.clear();
        Assert.assertTrue((String)"the subset is not empty", (boolean)subset.isEmpty());
        Assert.assertFalse((String)"the parent configuration is empty", (boolean)config.isEmpty());
    }

    @Test
    public void testSetListDelimiter() {
        BaseConfiguration config = new BaseConfiguration();
        Configuration subset = config.subset("prefix");
        config.setListDelimiter('/');
        subset.addProperty("list", (Object)"a/b/c");
        Assert.assertEquals((String)"Wrong size of list", (long)3L, (long)config.getList("prefix.list").size());
        ((AbstractConfiguration)subset).setListDelimiter(';');
        subset.addProperty("list2", (Object)"a;b;c");
        Assert.assertEquals((String)"Wrong size of list2", (long)3L, (long)config.getList("prefix.list2").size());
    }

    @Test
    public void testGetListDelimiter() {
        BaseConfiguration config = new BaseConfiguration();
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        config.setListDelimiter('/');
        Assert.assertEquals((String)"Wrong list delimiter in subset", (long)47L, (long)subset.getListDelimiter());
        subset.setListDelimiter(';');
        Assert.assertEquals((String)"Wrong list delimiter in parent", (long)59L, (long)config.getListDelimiter());
    }

    @Test
    public void testSetDelimiterParsingDisabled() {
        BaseConfiguration config = new BaseConfiguration();
        Configuration subset = config.subset("prefix");
        config.setDelimiterParsingDisabled(true);
        subset.addProperty("list", (Object)"a,b,c");
        Assert.assertEquals((String)"Wrong value of property", (Object)"a,b,c", (Object)config.getString("prefix.list"));
        ((AbstractConfiguration)subset).setDelimiterParsingDisabled(false);
        subset.addProperty("list2", (Object)"a,b,c");
        Assert.assertEquals((String)"Wrong size of list2", (long)3L, (long)config.getList("prefix.list2").size());
    }

    @Test
    public void testIsDelimiterParsingDisabled() {
        BaseConfiguration config = new BaseConfiguration();
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        config.setDelimiterParsingDisabled(true);
        Assert.assertTrue((String)"Wrong value of list parsing flag in subset", (boolean)subset.isDelimiterParsingDisabled());
        subset.setDelimiterParsingDisabled(false);
        Assert.assertFalse((String)"Wrong value of list parsing flag in parent", (boolean)config.isDelimiterParsingDisabled());
    }

    @Test
    public void testInterpolator() {
        BaseConfiguration config = new BaseConfiguration();
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        InterpolationTestHelper.testGetInterpolator(subset);
    }

    @Test
    public void testLocalLookupsInInterpolatorAreInherited() {
        BaseConfiguration config = new BaseConfiguration();
        ConfigurationInterpolator interpolator = config.getInterpolator();
        interpolator.registerLookup("brackets", new StrLookup(){

            public String lookup(String key) {
                return "(" + key + ")";
            }
        });
        config.setProperty("prefix.var", (Object)"${brackets:x}");
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        Assert.assertEquals((String)"Local lookup was not inherited", (Object)"(x)", (Object)subset.getString("var", ""));
    }

    @Test
    public void testInterpolationForKeysOfTheParent() {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("test", (Object)"junit");
        config.setProperty("prefix.key", (Object)"${test}");
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        Assert.assertEquals((String)"Interpolation does not resolve parent keys", (Object)"junit", (Object)subset.getString("key", ""));
    }
}

