/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.event;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.junit.Assert;

public class ConfigurationListenerTestImpl
implements ConfigurationListener {
    private final Object expectedSource;
    private final List<ConfigurationEvent> events;

    public ConfigurationListenerTestImpl(Object source) {
        this.expectedSource = source;
        this.events = new LinkedList<ConfigurationEvent>();
    }

    public void configurationChanged(ConfigurationEvent event) {
        this.events.add(event);
    }

    public void checkEventCount(int minEvents) {
        Assert.assertTrue((String)"Too view events received", (this.events.size() >= minEvents ? 1 : 0) != 0);
    }

    public void checkEvent(int type, String propName, Object propValue, boolean before) {
        ConfigurationEvent e = this.nextEvent(type);
        Assert.assertEquals((String)"Wrong property name", (Object)propName, (Object)e.getPropertyName());
        Assert.assertEquals((String)"Wrong property value", (Object)propValue, (Object)e.getPropertyValue());
        Assert.assertEquals((String)"Wrong before flag", (Object)before, (Object)e.isBeforeUpdate());
    }

    public ConfigurationEvent nextEvent(int expectedType) {
        Assert.assertFalse((String)"Too few events received", (boolean)this.events.isEmpty());
        ConfigurationEvent e = this.events.remove(0);
        if (this.expectedSource != null) {
            Assert.assertEquals((String)"Wrong event source", (Object)this.expectedSource, (Object)e.getSource());
        }
        Assert.assertEquals((String)"Wrong event type", (long)expectedType, (long)e.getType());
        return e;
    }

    public void skipToLast(int type) {
        while (this.events.size() > 1) {
            ConfigurationEvent e = this.events.remove(0);
            Assert.assertTrue((String)"Found end event in details", (type != e.getType() ? 1 : 0) != 0);
        }
    }

    public void done() {
        Assert.assertTrue((String)"Too many events received", (boolean)this.events.isEmpty());
    }
}

