/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.NoSuchElementException;
import org.apache.commons.configuration.tree.DefaultConfigurationKey;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultConfigurationKey {
    private static final String TESTPROPS = "tables.table(0).fields.field(1)";
    private static final String TESTATTR = "[@dataType]";
    private static final String TESTKEY = "tables.table(0).fields.field(1)[@dataType]";
    DefaultExpressionEngine expressionEngine;
    DefaultConfigurationKey key;

    @Before
    public void setUp() throws Exception {
        this.expressionEngine = new DefaultExpressionEngine();
        this.key = new DefaultConfigurationKey(this.expressionEngine);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNullExpressionEngine() {
        this.key.setExpressionEngine(null);
    }

    @Test
    public void testIsAttributeKey() {
        Assert.assertTrue((String)"Attribute key not detected", (boolean)this.key.isAttributeKey(TESTATTR));
        Assert.assertFalse((String)"Property key considered as attribute", (boolean)this.key.isAttributeKey(TESTPROPS));
        Assert.assertFalse((String)"Null key considered as attribute", (boolean)this.key.isAttributeKey(null));
    }

    @Test
    public void testIsAttributeKeyWithoutEndMarkers() {
        this.expressionEngine.setAttributeEnd(null);
        this.expressionEngine.setAttributeStart(".");
        Assert.assertTrue((String)"Attribute key not detected", (boolean)this.key.isAttributeKey(".test"));
        Assert.assertFalse((String)"Property key considered as attribute key", (boolean)this.key.isAttributeKey(TESTATTR));
    }

    @Test
    public void testTrimLeft() {
        Assert.assertEquals((String)"Key was not left trimmed", (Object)"test.", (Object)this.key.trimLeft(".test."));
        Assert.assertEquals((String)"Too much left trimming", (Object)"..test.", (Object)this.key.trimLeft("..test."));
    }

    @Test
    public void testTrimRight() {
        Assert.assertEquals((String)"Key was not right trimmed", (Object)".test", (Object)this.key.trimRight(".test."));
        Assert.assertEquals((String)"Too much right trimming", (Object)".test..", (Object)this.key.trimRight(".test.."));
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((String)"Key was not trimmed", (Object)"test", (Object)this.key.trim(".test."));
        Assert.assertEquals((String)"Null key could not be processed", (Object)"", (Object)this.key.trim(null));
        Assert.assertEquals((String)"Delimiter could not be processed", (Object)"", (Object)this.key.trim("."));
    }

    @Test
    public void testAppend() {
        this.key.append("tables").append("table(0).");
        this.key.append("fields.").append("field(1)");
        this.key.append(null).append(TESTATTR);
        Assert.assertEquals((String)"Wrong key", (Object)TESTKEY, (Object)this.key.toString());
    }

    @Test
    public void testAppendDelimiters() {
        this.key.append("key..").append("test").append(".");
        this.key.append(".more").append("..tests");
        Assert.assertEquals((String)"Wrong key", (Object)"key...test.more...tests", (Object)this.key.toString());
    }

    @Test
    public void testAppendDelimitersWithoutEscaping() {
        this.expressionEngine.setEscapedDelimiter(null);
        this.key.append("key.......").append("test").append(".");
        this.key.append(".more").append("..tests");
        Assert.assertEquals((String)"Wrong constructed key", (Object)"key.test.more.tests", (Object)this.key.toString());
    }

    @Test
    public void testAppendWithEscapeFlag() {
        this.key.append(".key.test.", true);
        this.key.append(".more").append(".tests", true);
        Assert.assertEquals((String)"Wrong constructed key", (Object)"..key..test...more...tests", (Object)this.key.toString());
    }

    @Test
    public void testConstructAttributeKey() {
        Assert.assertEquals((String)"Wrong attribute key", (Object)TESTATTR, (Object)this.key.constructAttributeKey("dataType"));
        Assert.assertEquals((String)"Attribute key was incorrectly converted", (Object)TESTATTR, (Object)this.key.constructAttributeKey(TESTATTR));
        Assert.assertEquals((String)"Null key could not be processed", (Object)"", (Object)this.key.constructAttributeKey(null));
    }

    @Test
    public void testConstructAttributeKeyWithoutEndMarkers() {
        this.expressionEngine.setAttributeEnd(null);
        this.expressionEngine.setAttributeStart(this.expressionEngine.getPropertyDelimiter());
        Assert.assertEquals((String)"Wrong attribute key", (Object)".test", (Object)this.key.constructAttributeKey("test"));
        Assert.assertEquals((String)"Attribute key was incorrectly converted", (Object)".test", (Object)this.key.constructAttributeKey(".test"));
    }

    @Test
    public void testAppendAttribute() {
        this.key.appendAttribute("dataType");
        Assert.assertEquals((String)"Attribute key not correctly appended", (Object)TESTATTR, (Object)this.key.toString());
    }

    @Test
    public void testAppendDecoratedAttributeKey() {
        this.key.appendAttribute(TESTATTR);
        Assert.assertEquals((String)"Decorated attribute key not correctly appended", (Object)TESTATTR, (Object)this.key.toString());
    }

    @Test
    public void testAppendNullAttributeKey() {
        this.key.appendAttribute(null);
        Assert.assertEquals((String)"Null attribute key not correctly appended", (Object)"", (Object)this.key.toString());
    }

    @Test
    public void testAppendIndex() {
        this.key.append("test").appendIndex(42);
        Assert.assertEquals((String)"Index was not correctly appended", (Object)"test(42)", (Object)this.key.toString());
    }

    @Test
    public void testAppendComplexKey() {
        this.key.append("tables").append("table.").appendIndex(0);
        this.key.append("fields.").append("field").appendIndex(1);
        this.key.appendAttribute("dataType");
        Assert.assertEquals((String)"Wrong complex key", (Object)TESTKEY, (Object)this.key.toString());
    }

    @Test
    public void testLength() {
        this.key.append(TESTPROPS);
        Assert.assertEquals((String)"Wrong length", (long)TESTPROPS.length(), (long)this.key.length());
        this.key.appendAttribute("dataType");
        Assert.assertEquals((String)"Wrong length", (long)TESTKEY.length(), (long)this.key.length());
        this.key.setLength(TESTPROPS.length());
        Assert.assertEquals((String)"Wrong length after shortening", (long)TESTPROPS.length(), (long)this.key.length());
        Assert.assertEquals((String)"Wrong resulting key", (Object)TESTPROPS, (Object)this.key.toString());
    }

    @Test
    public void testEquals() {
        DefaultConfigurationKey k1 = new DefaultConfigurationKey(this.expressionEngine, TESTKEY);
        DefaultConfigurationKey k2 = new DefaultConfigurationKey(this.expressionEngine, TESTKEY);
        Assert.assertTrue((String)"Keys are not equal", (boolean)k1.equals((Object)k2));
        Assert.assertTrue((String)"Not reflexiv", (boolean)k2.equals((Object)k1));
        Assert.assertEquals((String)"Hash codes not equal", (long)k1.hashCode(), (long)k2.hashCode());
        k2.append("anotherPart");
        Assert.assertFalse((String)"Keys considered equal", (boolean)k1.equals((Object)k2));
        Assert.assertFalse((String)"Keys considered equal", (boolean)k2.equals((Object)k1));
        Assert.assertFalse((String)"Key equals null key", (boolean)k1.equals(null));
        Assert.assertTrue((String)"Faild comparison with string", (boolean)k1.equals((Object)TESTKEY));
    }

    @Test
    public void testAttributeName() {
        Assert.assertEquals((String)"Plain key not detected", (Object)"test", (Object)this.key.attributeName("test"));
        Assert.assertEquals((String)"Attribute markers not stripped", (Object)"dataType", (Object)this.key.attributeName(TESTATTR));
        Assert.assertNull((String)"Null key not processed", (Object)this.key.attributeName(null));
    }

    @Test
    public void testIterate() {
        this.key.append(TESTKEY);
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assert.assertTrue((String)"No key parts", (boolean)it.hasNext());
        Assert.assertEquals((String)"Wrong key part", (Object)"tables", (Object)it.nextKey());
        Assert.assertEquals((String)"Wrong key part", (Object)"table", (Object)it.nextKey());
        Assert.assertTrue((String)"No index found", (boolean)it.hasIndex());
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)it.getIndex());
        Assert.assertEquals((String)"Wrong key part", (Object)"fields", (Object)it.nextKey());
        Assert.assertFalse((String)"Found an index", (boolean)it.hasIndex());
        Assert.assertEquals((String)"Wrong key part", (Object)"field", (Object)it.nextKey(true));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)it.getIndex());
        Assert.assertFalse((String)"Found an attribute", (boolean)it.isAttribute());
        Assert.assertEquals((String)"Wrong current key", (Object)"field", (Object)it.currentKey(true));
        Assert.assertEquals((String)"Wrong key part", (Object)"dataType", (Object)it.nextKey());
        Assert.assertEquals((String)"Wrong decorated key part", (Object)TESTATTR, (Object)it.currentKey(true));
        Assert.assertTrue((String)"Attribute not found", (boolean)it.isAttribute());
        Assert.assertFalse((String)"Too many key parts", (boolean)it.hasNext());
        try {
            it.next();
            Assert.fail((String)"Could iterate over the iteration's end!");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIterateWithRemove() {
        Assert.assertFalse((boolean)this.key.iterator().hasNext());
        this.key.append("simple");
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"simple", (Object)it.next());
        it.remove();
    }

    @Test
    public void testIterateStrangeKeys() {
        this.key = new DefaultConfigurationKey(this.expressionEngine, "key.");
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assert.assertTrue((String)"Too few key parts", (boolean)it.hasNext());
        Assert.assertEquals((String)"Wrong key part", (Object)"key", (Object)it.next());
        Assert.assertFalse((String)"Too many key parts", (boolean)it.hasNext());
        this.key = new DefaultConfigurationKey(this.expressionEngine, ".");
        it = this.key.iterator();
        Assert.assertFalse((String)"Simple delimiter key has more parts", (boolean)it.hasNext());
        this.key = new DefaultConfigurationKey(this.expressionEngine, "key().index()undefined(0).test");
        it = this.key.iterator();
        Assert.assertEquals((String)"Wrong first part", (Object)"key()", (Object)it.next());
        Assert.assertFalse((String)"Index detected in first part", (boolean)it.hasIndex());
        Assert.assertEquals((String)"Wrong second part", (Object)"index()undefined", (Object)it.nextKey(false));
        Assert.assertTrue((String)"No index detected in second part", (boolean)it.hasIndex());
        Assert.assertEquals((String)"Wrong index value", (long)0L, (long)it.getIndex());
    }

    @Test
    public void testIterateEscapedDelimiters() {
        this.key.append("my..elem");
        this.key.append("trailing..dot..");
        this.key.append(".strange");
        Assert.assertEquals((Object)"my..elem.trailing..dot...strange", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        Assert.assertEquals((String)"Wrong first part", (Object)"my.elem", (Object)kit.nextKey());
        Assert.assertEquals((String)"Wrong second part", (Object)"trailing.dot.", (Object)kit.nextKey());
        Assert.assertEquals((String)"Wrong third part", (Object)"strange", (Object)kit.nextKey());
        Assert.assertFalse((String)"Too many parts", (boolean)kit.hasNext());
    }

    @Test
    public void testIterateAlternativeEscapeDelimiter() {
        this.expressionEngine.setEscapedDelimiter("\\.");
        this.key.append("\\.my\\.elem");
        this.key.append("trailing\\.dot\\.");
        this.key.append(".strange");
        Assert.assertEquals((Object)"\\.my\\.elem.trailing\\.dot\\..strange", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        Assert.assertEquals((String)"Wrong first part", (Object)".my.elem", (Object)kit.nextKey());
        Assert.assertEquals((String)"Wrong second part", (Object)"trailing.dot.", (Object)kit.nextKey());
        Assert.assertEquals((String)"Wrong third part", (Object)"strange", (Object)kit.nextKey());
        Assert.assertFalse((String)"Too many parts", (boolean)kit.hasNext());
    }

    @Test
    public void testIterateWithoutEscapeDelimiter() {
        this.expressionEngine.setEscapedDelimiter(null);
        this.key.append("..my..elem.trailing..dot...strange");
        Assert.assertEquals((String)"Wrong key", (Object)"my..elem.trailing..dot...strange", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        String[] parts = new String[]{"my", "elem", "trailing", "dot", "strange"};
        for (int i = 0; i < parts.length; ++i) {
            Assert.assertEquals((String)("Wrong key part " + i), (Object)parts[i], (Object)kit.next());
        }
        Assert.assertFalse((String)"Too many parts", (boolean)kit.hasNext());
    }

    @Test
    public void testIterateWithBrackets() {
        this.key.append("directory.platform(x86).path");
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        String part = kit.nextKey();
        Assert.assertEquals((String)"Wrong part 1", (Object)"directory", (Object)part);
        Assert.assertFalse((String)"Has index 1", (boolean)kit.hasIndex());
        part = kit.nextKey();
        Assert.assertEquals((String)"Wrong part 2", (Object)"platform(x86)", (Object)part);
        Assert.assertFalse((String)"Has index 2", (boolean)kit.hasIndex());
        part = kit.nextKey();
        Assert.assertEquals((String)"Wrong part 3", (Object)"path", (Object)part);
        Assert.assertFalse((String)"Has index 3", (boolean)kit.hasIndex());
        Assert.assertFalse((String)"Too many elements", (boolean)kit.hasNext());
    }

    @Test
    public void testAttributeKeyWithIndex() {
        this.key.append(TESTATTR);
        this.key.appendIndex(0);
        Assert.assertEquals((String)"Wrong attribute key with index", (Object)"[@dataType](0)", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assert.assertTrue((String)"No first element", (boolean)it.hasNext());
        it.next();
        Assert.assertTrue((String)"Index not found", (boolean)it.hasIndex());
        Assert.assertEquals((String)"Incorrect index", (long)0L, (long)it.getIndex());
        Assert.assertTrue((String)"Attribute not found", (boolean)it.isAttribute());
        Assert.assertEquals((String)"Wrong plain key", (Object)"dataType", (Object)it.currentKey(false));
        Assert.assertEquals((String)"Wrong decorated key", (Object)TESTATTR, (Object)it.currentKey(true));
    }

    @Test
    public void testIterateAttributeEqualsPropertyDelimiter() {
        this.expressionEngine.setAttributeEnd(null);
        this.expressionEngine.setAttributeStart(this.expressionEngine.getPropertyDelimiter());
        this.key.append("this.isa.key");
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        Assert.assertEquals((String)"Wrong first key part", (Object)"this", (Object)kit.next());
        Assert.assertFalse((String)"First part is an attribute", (boolean)kit.isAttribute());
        Assert.assertTrue((String)"First part is not a property key", (boolean)kit.isPropertyKey());
        Assert.assertEquals((String)"Wrong second key part", (Object)"isa", (Object)kit.next());
        Assert.assertFalse((String)"Second part is an attribute", (boolean)kit.isAttribute());
        Assert.assertTrue((String)"Second part is not a property key", (boolean)kit.isPropertyKey());
        Assert.assertEquals((String)"Wrong third key part", (Object)"key", (Object)kit.next());
        Assert.assertTrue((String)"Third part is not an attribute", (boolean)kit.isAttribute());
        Assert.assertTrue((String)"Third part is not a property key", (boolean)kit.isPropertyKey());
        Assert.assertEquals((String)"Wrong decorated key part", (Object)"key", (Object)kit.currentKey(true));
    }
}

