/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.NodeAddData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultExpressionEngine {
    private static String[] tables = new String[]{"users", "documents"};
    private static String[] tabTypes = new String[]{"system", "application"};
    private static String[][] fields = new String[][]{{"uid", "uname", "firstName", "lastName", "email"}, {"docid", "name", "creationDate", "authorID", "version"}};
    DefaultExpressionEngine engine;
    ConfigurationNode root;

    @Before
    public void setUp() throws Exception {
        this.root = this.setUpNodes();
        this.engine = new DefaultExpressionEngine();
    }

    @Test
    public void testQueryKeys() {
        this.checkKey("tables.table.name", "name", 2);
        this.checkKey("tables.table.fields.field.name", "name", 10);
        this.checkKey("tables.table[@type]", "type", 2);
        this.checkKey("tables.table(0).fields.field.name", "name", 5);
        this.checkKey("tables.table(1).fields.field.name", "name", 5);
        this.checkKey("tables.table.fields.field(1).name", "name", 2);
    }

    @Test
    public void testQueryNodes() {
        for (int i = 0; i < tables.length; ++i) {
            this.checkKeyValue("tables.table(" + i + ").name", "name", tables[i]);
            this.checkKeyValue("tables.table(" + i + ")[@type]", "type", tabTypes[i]);
            for (int j = 0; j < fields[i].length; ++j) {
                this.checkKeyValue("tables.table(" + i + ").fields.field(" + j + ").name", "name", fields[i][j]);
            }
        }
    }

    @Test
    public void testQueryNonExistingKeys() {
        this.checkKey("tables.tablespace.name", null, 0);
        this.checkKey("tables.table(2).name", null, 0);
        this.checkKey("a complete unknown key", null, 0);
        this.checkKey("tables.table(0).fields.field(-1).name", null, 0);
        this.checkKey("tables.table(0).fields.field(28).name", null, 0);
        this.checkKey("tables.table(0).fields.field().name", null, 0);
        this.checkKey("connection.settings.usr.name", null, 0);
    }

    @Test
    public void testQueryEscapedKeys() {
        this.checkKeyValue("connection..settings.usr..name", "usr.name", "scott");
        this.checkKeyValue("connection..settings.usr..pwd", "usr.pwd", "tiger");
    }

    @Test
    public void testQueryAttributeEmulation() {
        this.engine.setAttributeEnd(null);
        this.engine.setAttributeStart(this.engine.getPropertyDelimiter());
        this.checkKeyValue("tables.table(0).name", "name", tables[0]);
        this.checkKeyValue("tables.table(0).type", "type", tabTypes[0]);
        this.checkKey("tables.table.type", "type", 2);
    }

    @Test
    public void testQueryRootNode() {
        List<ConfigurationNode> nodes = this.checkKey(null, null, 1);
        Assert.assertSame((String)"Root node not found", (Object)this.root, (Object)nodes.get(0));
        nodes = this.checkKey("", null, 1);
        Assert.assertSame((String)"Root node not found", (Object)this.root, (Object)nodes.get(0));
        this.checkKeyValue("[@test]", "test", "true");
    }

    @Test
    public void testQueryAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        this.checkKeyValue("tables/table[1]/name", "name", tables[1]);
        this.checkKeyValue("tables/table[0]@type", "type", tabTypes[0]);
        this.checkKeyValue("@test", "test", "true");
        this.checkKeyValue("connection.settings/usr.name", "usr.name", "scott");
    }

    @Test
    public void testNodeKey() {
        ConfigurationNode node = this.root.getChild(0);
        Assert.assertEquals((String)"Invalid name for descendant of root", (Object)"tables", (Object)this.engine.nodeKey(node, ""));
        Assert.assertEquals((String)"Parent key not respected", (Object)"test.tables", (Object)this.engine.nodeKey(node, "test"));
        Assert.assertEquals((String)"Full parent key not taken into account", (Object)"a.full.parent.key.tables", (Object)this.engine.nodeKey(node, "a.full.parent.key"));
    }

    @Test
    public void testNodeKeyWithRoot() {
        Assert.assertEquals((String)"Wrong name for root noot", (Object)"", (Object)this.engine.nodeKey(this.root, null));
        Assert.assertEquals((String)"Null name not detected", (Object)"test", (Object)this.engine.nodeKey(this.root, "test"));
    }

    @Test
    public void testNodeKeyWithAttribute() {
        ConfigurationNode node = this.root.getChild(0).getChild(0).getAttribute(0);
        Assert.assertEquals((String)"Wrong attribute node", (Object)"type", (Object)node.getName());
        Assert.assertEquals((String)"Wrong attribute key", (Object)"tables.table[@type]", (Object)this.engine.nodeKey(node, "tables.table"));
        Assert.assertEquals((String)"Wrong key for root attribute", (Object)"[@test]", (Object)this.engine.nodeKey(this.root.getAttribute(0), ""));
    }

    @Test
    public void testNodeKeyWithEscapedDelimiters() {
        ConfigurationNode node = this.root.getChild(1);
        Assert.assertEquals((String)"Wrong escaped key", (Object)"connection..settings", (Object)this.engine.nodeKey(node, ""));
        Assert.assertEquals((String)"Wrong complex escaped key", (Object)"connection..settings.usr..name", (Object)this.engine.nodeKey(node.getChild(0), this.engine.nodeKey(node, "")));
    }

    @Test
    public void testNodeKeyWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        Assert.assertEquals((String)"Wrong child key", (Object)"tables/table", (Object)this.engine.nodeKey(this.root.getChild(0).getChild(0), "tables"));
        Assert.assertEquals((String)"Wrong attribute key", (Object)"@test", (Object)this.engine.nodeKey(this.root.getAttribute(0), ""));
        this.engine.setAttributeStart(this.engine.getPropertyDelimiter());
        Assert.assertEquals((String)"Wrong attribute key", (Object)"/test", (Object)this.engine.nodeKey(this.root.getAttribute(0), ""));
    }

    @Test
    public void testPrepareAddDirectly() {
        NodeAddData data = this.engine.prepareAdd(this.root, "newNode");
        Assert.assertSame((String)"Wrong parent node", (Object)this.root, (Object)data.getParent());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
        Assert.assertEquals((String)"Wrong name of new node", (Object)"newNode", (Object)data.getNewNodeName());
        Assert.assertFalse((String)"New node is an attribute", (boolean)data.isAttribute());
        data = this.engine.prepareAdd(this.root, "tables.table.fields.field.name");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"name", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
        Assert.assertEquals((String)"Wrong parent node", (Object)"field", (Object)data.getParent().getName());
        ConfigurationNode nd = data.getParent().getChild(0);
        Assert.assertEquals((String)"Field has no name node", (Object)"name", (Object)nd.getName());
        Assert.assertEquals((String)"Incorrect name", (Object)"version", (Object)nd.getValue());
    }

    @Test
    public void testPrepareAddWithIndex() {
        NodeAddData data = this.engine.prepareAdd(this.root, "tables.table(0).tableSpace");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"tableSpace", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"table", (Object)data.getParent().getName());
        ConfigurationNode node = data.getParent().getChild(0);
        Assert.assertEquals((String)"Wrong table", (Object)tables[0], (Object)node.getValue());
        data = this.engine.prepareAdd(this.root, "tables.table(1).fields.field(2).alias");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"alias", (Object)data.getNewNodeName());
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"field", (Object)data.getParent().getName());
        Assert.assertEquals((String)"Wrong field node", (Object)"creationDate", (Object)data.getParent().getChild(0).getValue());
    }

    @Test
    public void testPrepareAddAttribute() {
        NodeAddData data = this.engine.prepareAdd(this.root, "tables.table(0)[@tableSpace]");
        Assert.assertEquals((String)"Wrong table node", (Object)tables[0], (Object)data.getParent().getChild(0).getValue());
        Assert.assertEquals((String)"Wrong name of new node", (Object)"tableSpace", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Attribute not detected", (boolean)data.isAttribute());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
        data = this.engine.prepareAdd(this.root, "[@newAttr]");
        Assert.assertSame((String)"Root node is not parent", (Object)this.root, (Object)data.getParent());
        Assert.assertEquals((String)"Wrong name of new node", (Object)"newAttr", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Attribute not detected", (boolean)data.isAttribute());
    }

    @Test
    public void testPrepareAddWithPath() {
        NodeAddData data = this.engine.prepareAdd(this.root, "tables.table(1).fields.field(-1).name");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"name", (Object)data.getNewNodeName());
        this.checkNodePath(data, new String[]{"field"});
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"fields", (Object)data.getParent().getName());
        data = this.engine.prepareAdd(this.root, "tables.table(-1).name");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"name", (Object)data.getNewNodeName());
        this.checkNodePath(data, new String[]{"table"});
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"tables", (Object)data.getParent().getName());
        data = this.engine.prepareAdd(this.root, "a.complete.new.path");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"path", (Object)data.getNewNodeName());
        this.checkNodePath(data, new String[]{"a", "complete", "new"});
        Assert.assertSame((String)"Root is not parent", (Object)this.root, (Object)data.getParent());
    }

    @Test
    public void testPrepareAddWithSameAttributeDelimiter() {
        this.engine.setAttributeEnd(null);
        this.engine.setAttributeStart(this.engine.getPropertyDelimiter());
        NodeAddData data = this.engine.prepareAdd(this.root, "tables.table(0).test");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"test", (Object)data.getNewNodeName());
        Assert.assertFalse((String)"New node is an attribute", (boolean)data.isAttribute());
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"table", (Object)data.getParent().getName());
        data = this.engine.prepareAdd(this.root, "a.complete.new.path");
        Assert.assertFalse((String)"New node is an attribute", (boolean)data.isAttribute());
        this.checkNodePath(data, new String[]{"a", "complete", "new"});
    }

    @Test
    public void testPrepareAddWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        NodeAddData data = this.engine.prepareAdd(this.root, "tables/table[0]/test");
        Assert.assertEquals((String)"Wrong name of new node", (Object)"test", (Object)data.getNewNodeName());
        Assert.assertFalse((String)"New node is attribute", (boolean)data.isAttribute());
        Assert.assertEquals((String)"Wrong parent node", (Object)tables[0], (Object)data.getParent().getChild(0).getValue());
        data = this.engine.prepareAdd(this.root, "a/complete/new/path@attr");
        Assert.assertEquals((String)"Wrong name of new attribute", (Object)"attr", (Object)data.getNewNodeName());
        this.checkNodePath(data, new String[]{"a", "complete", "new", "path"});
        Assert.assertSame((String)"Root is not parent", (Object)this.root, (Object)data.getParent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidKey() {
        this.engine.prepareAdd(this.root, "tables.table(0)[@type].new");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidKeyAttribute() {
        this.engine.prepareAdd(this.root, "a.complete.new.path.with.an[@attribute].at.a.non.allowed[@position]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddNullKey() {
        this.engine.prepareAdd(this.root, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddEmptyKey() {
        this.engine.prepareAdd(this.root, "");
    }

    protected ConfigurationNode setUpNodes() {
        DefaultConfigurationNode rootNode = new DefaultConfigurationNode();
        DefaultConfigurationNode nodeTables = new DefaultConfigurationNode("tables");
        rootNode.addChild((ConfigurationNode)nodeTables);
        for (int i = 0; i < tables.length; ++i) {
            DefaultConfigurationNode nodeTable = new DefaultConfigurationNode("table");
            nodeTables.addChild((ConfigurationNode)nodeTable);
            nodeTable.addChild((ConfigurationNode)new DefaultConfigurationNode("name", (Object)tables[i]));
            nodeTable.addAttribute((ConfigurationNode)new DefaultConfigurationNode("type", (Object)tabTypes[i]));
            DefaultConfigurationNode nodeFields = new DefaultConfigurationNode("fields");
            nodeTable.addChild((ConfigurationNode)nodeFields);
            for (int j = 0; j < fields[i].length; ++j) {
                nodeFields.addChild(TestDefaultExpressionEngine.createFieldNode(fields[i][j]));
            }
        }
        DefaultConfigurationNode nodeConn = new DefaultConfigurationNode("connection.settings");
        rootNode.addChild((ConfigurationNode)nodeConn);
        nodeConn.addChild((ConfigurationNode)new DefaultConfigurationNode("usr.name", (Object)"scott"));
        nodeConn.addChild((ConfigurationNode)new DefaultConfigurationNode("usr.pwd", (Object)"tiger"));
        rootNode.addAttribute((ConfigurationNode)new DefaultConfigurationNode("test", (Object)"true"));
        return rootNode;
    }

    private void setUpAlternativeSyntax() {
        this.engine.setAttributeEnd(null);
        this.engine.setAttributeStart("@");
        this.engine.setPropertyDelimiter("/");
        this.engine.setEscapedDelimiter(null);
        this.engine.setIndexStart("[");
        this.engine.setIndexEnd("]");
    }

    private List<ConfigurationNode> checkKey(String key, String name, int count) {
        List nodes = this.engine.query(this.root, key);
        Assert.assertEquals((String)("Wrong number of result nodes for key " + key), (long)count, (long)nodes.size());
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Assert.assertEquals((String)("Wrong result node for key " + key), (Object)name, (Object)((ConfigurationNode)it.next()).getName());
        }
        return nodes;
    }

    private void checkKeyValue(String key, String name, String value) {
        List<ConfigurationNode> nodes = this.checkKey(key, name, 1);
        Assert.assertEquals((String)("Wrong value for key " + key), (Object)value, (Object)nodes.get(0).getValue());
    }

    private void checkNodePath(NodeAddData data, String[] expected) {
        Assert.assertEquals((String)"Wrong number of path nodes", (long)expected.length, (long)data.getPathNodes().size());
        Iterator it = data.getPathNodes().iterator();
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("Wrong path node " + i), (Object)expected[i], it.next());
        }
    }

    private static ConfigurationNode createFieldNode(String name) {
        DefaultConfigurationNode nodeField = new DefaultConfigurationNode("field");
        nodeField.addChild((ConfigurationNode)new DefaultConfigurationNode("name", (Object)name));
        return nodeField;
    }
}

