/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.spring;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.spring.ConfigurationPropertySource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration
public class TestConfigurationPropertySource {
    private static final String TEST_PROPERTY = "test.property";
    private static final String TEST_LIST_PROPERTY = "test.list.property";
    private static final String TEST_SYSTEM_PROPERTY = "test.system.property";
    private static final String TEST_NULL_PROPERTY = "test.null.property";
    private static final String TEST_EMPTY_PROPERTY = "test.empty.property";
    private static final String TEST_VALUE = "testVALUE";
    private static final String TEST_SYSTEM_VALUE = "testVALUEforSystemEnv";
    private static final String TEST_SYSTEM_PROPERTY_VALUE = "${sys:test.system.property}";
    private static final String[] TEST_LIST_PROPERTY_VALUE = new String[]{"${sys:test.system.property}", "testVALUE"};
    private static final String[] TEST_LIST_VALUE = new String[]{"testVALUEforSystemEnv", "testVALUE"};
    @Value(value="${test.property}")
    private String value;
    @Value(value="${test.list.property}")
    private String[] listValue;
    @Value(value="${test.system.property}")
    private String systemPropertyValue;
    @Value(value="${test.null.property:false}")
    private boolean booleanNullValueDefaultFalse;
    @Value(value="${test.null.property:true}")
    private boolean booleanNullValueDefaultTrue;
    @Value(value="${test.empty.property:defaultShouldNotApply}")
    private String emptyPropertyValue;

    private static ConfigurationPropertySource createConfigPropertySource() {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.addProperty(TEST_PROPERTY, (Object)TEST_VALUE);
        propertiesConfiguration.addProperty(TEST_LIST_PROPERTY, (Object)TEST_LIST_PROPERTY_VALUE);
        propertiesConfiguration.addProperty(TEST_SYSTEM_PROPERTY, (Object)TEST_SYSTEM_PROPERTY_VALUE);
        propertiesConfiguration.addProperty(TEST_NULL_PROPERTY, null);
        propertiesConfiguration.addProperty(TEST_EMPTY_PROPERTY, (Object)"");
        return new ConfigurationPropertySource("test configuration", (Configuration)propertiesConfiguration);
    }

    @BeforeAll
    public static void setUp() {
        System.setProperty(TEST_SYSTEM_PROPERTY, TEST_SYSTEM_VALUE);
    }

    @AfterAll
    public static void tearDown() {
        System.clearProperty(TEST_SYSTEM_PROPERTY);
    }

    @Test
    void testEmptyStringValueInjection() {
        Assertions.assertEquals((Object)"", (Object)this.emptyPropertyValue);
    }

    @Test
    void testListValueInjection() {
        Assertions.assertArrayEquals((Object[])TEST_LIST_VALUE, (Object[])this.listValue);
    }

    @Test
    void testNullValueInjection() {
        Assertions.assertFalse((boolean)this.booleanNullValueDefaultFalse);
        Assertions.assertTrue((boolean)this.booleanNullValueDefaultTrue);
    }

    @Test
    void testSystemPropertyValueInjection() {
        Assertions.assertEquals((Object)TEST_SYSTEM_VALUE, (Object)this.systemPropertyValue);
    }

    @org.springframework.context.annotation.Configuration
    static class Config {
        Config() {
        }

        @Bean
        public PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer(ConfigurableEnvironment env) {
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            MutablePropertySources sources = new MutablePropertySources();
            sources.addLast((PropertySource)TestConfigurationPropertySource.createConfigPropertySource());
            configurer.setPropertySources((PropertySources)sources);
            configurer.setEnvironment((Environment)env);
            return configurer;
        }
    }
}

