/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.impl.SimpleLog;

public class StackMessageLog
extends SimpleLog {
    private static final long serialVersionUID = 1L;
    private static final Stack<String> MESSAGE_STACK = new Stack();
    private static final Lock LOCK = new ReentrantLock();

    public static void clear() {
        LOCK.lock();
        try {
            MESSAGE_STACK.clear();
        }
        finally {
            LOCK.unlock();
        }
    }

    public static List<String> getAll() {
        return new ArrayList<String>(MESSAGE_STACK);
    }

    public static boolean isEmpty() {
        return MESSAGE_STACK.isEmpty();
    }

    public static void lock() {
        LOCK.lock();
    }

    public static String popMessage() {
        LOCK.lock();
        try {
            String string = MESSAGE_STACK.pop();
            return string;
        }
        catch (EmptyStackException ex) {
            String string = null;
            return string;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void unLock() {
        try {
            LOCK.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public StackMessageLog(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(int type, Object message, Throwable t) {
        LOCK.lock();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(message.toString());
            if (t != null) {
                buf.append(" <");
                buf.append(t.toString());
                buf.append(">");
                StringWriter sw = new StringWriter(1024);
                try (PrintWriter pw = new PrintWriter(sw);){
                    t.printStackTrace(pw);
                }
                buf.append(sw.toString());
            }
            MESSAGE_STACK.push(buf.toString());
        }
        finally {
            LOCK.unlock();
        }
    }
}

