/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.handlers.ArrayListHandler;

public class ArrayListHandlerTest
extends BaseTestCase {
    public void testEmptyResultSetHandle() throws SQLException {
        ArrayListHandler h = new ArrayListHandler();
        List results = (List)h.handle(this.emptyResultSet);
        ArrayListHandlerTest.assertNotNull((Object)results);
        ArrayListHandlerTest.assertTrue((boolean)results.isEmpty());
    }

    public void testHandle() throws SQLException {
        ArrayListHandler h = new ArrayListHandler();
        List results = (List)h.handle(this.rs);
        ArrayListHandlerTest.assertNotNull((Object)results);
        ArrayListHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Iterator iter = results.iterator();
        ArrayListHandlerTest.assertTrue((boolean)iter.hasNext());
        Object[] row = (Object[])iter.next();
        ArrayListHandlerTest.assertEquals((int)COLS, (int)row.length);
        ArrayListHandlerTest.assertEquals((Object)"1", (Object)row[0]);
        ArrayListHandlerTest.assertEquals((Object)"2", (Object)row[1]);
        ArrayListHandlerTest.assertEquals((Object)"THREE", (Object)row[2]);
        ArrayListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (Object[])iter.next();
        ArrayListHandlerTest.assertEquals((int)COLS, (int)row.length);
        ArrayListHandlerTest.assertEquals((Object)"4", (Object)row[0]);
        ArrayListHandlerTest.assertEquals((Object)"5", (Object)row[1]);
        ArrayListHandlerTest.assertEquals((Object)"SIX", (Object)row[2]);
        ArrayListHandlerTest.assertFalse((boolean)iter.hasNext());
    }
}

