/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.nio.ByteOrder;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.common.ByteConversions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BinaryFileFunctionsTest
extends AbstractImagingTest {
    private static final long TARGET_LONG = 72623859790382856L;

    @Test
    public void testDoubleToByteConversion() {
        byte[] bytesLE = ByteConversions.toBytes((double)1.0, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((double)ByteConversions.toDouble((byte[])bytesLE, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (double)1.0, (double)0.0);
        byte[] bytesBE = ByteConversions.toBytes((double)1.0, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Assertions.assertEquals((double)ByteConversions.toDouble((byte[])bytesBE, (ByteOrder)ByteOrder.BIG_ENDIAN), (double)1.0, (double)0.0);
    }

    @Test
    public void testFloatToByteConversion() {
        byte[] bytesLE = ByteConversions.toBytes((float)1.0f, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((float)ByteConversions.toFloat((byte[])bytesLE, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (float)1.0f, (float)0.0f);
        byte[] bytesBE = ByteConversions.toBytes((float)1.0f, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Assertions.assertEquals((float)ByteConversions.toFloat((byte[])bytesBE, (ByteOrder)ByteOrder.BIG_ENDIAN), (float)1.0f, (float)0.0f);
    }

    @Test
    public void testLongToByteConversion() {
        byte[] bytesLE = ByteConversions.toBytes((long)72623859790382856L, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((long)ByteConversions.toLong((byte[])bytesLE, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (long)72623859790382856L);
        byte[] bytesBE = ByteConversions.toBytes((long)72623859790382856L, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Assertions.assertEquals((long)ByteConversions.toLong((byte[])bytesBE, (ByteOrder)ByteOrder.BIG_ENDIAN), (long)72623859790382856L);
    }
}

