/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.AbstractExifTest;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.jpeg.iptc.JpegIptcRewriter;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpRewriter;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.constants.MicrosoftTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MicrosoftTagTest
extends AbstractExifTest {
    private static final String AUTHOR = "author";
    private static final String COMMENT = "comment";
    private static final String SUBJECT = "subject";
    private static final String TITLE = "title";

    private void checkFields(byte[] file) throws Exception {
        TiffImageMetadata metadata = this.toTiffMetadata(Imaging.getMetadata((byte[])file));
        ArrayList<String> authorValues = new ArrayList<String>();
        ArrayList<String> commentValues = new ArrayList<String>();
        ArrayList<String> subjectValues = new ArrayList<String>();
        ArrayList<String> titleValues = new ArrayList<String>();
        for (TiffDirectory d : metadata.contents.directories) {
            titleValues.add(d.getFieldValue(MicrosoftTagConstants.EXIF_TAG_XPTITLE, false));
            authorValues.add(d.getFieldValue(MicrosoftTagConstants.EXIF_TAG_XPAUTHOR, false));
            commentValues.add(d.getFieldValue(MicrosoftTagConstants.EXIF_TAG_XPCOMMENT, false));
            subjectValues.add(d.getFieldValue(MicrosoftTagConstants.EXIF_TAG_XPSUBJECT, false));
        }
        Assertions.assertTrue((boolean)authorValues.contains(AUTHOR));
        Assertions.assertTrue((boolean)commentValues.contains(COMMENT));
        Assertions.assertTrue((boolean)subjectValues.contains(SUBJECT));
        Assertions.assertTrue((boolean)titleValues.contains(TITLE));
    }

    private byte[] cleanImage(File imageWithExif) throws ImagingException, ImagingException, IOException {
        ByteArrayOutputStream noXmp = new ByteArrayOutputStream();
        new JpegXmpRewriter().removeXmpXml(imageWithExif, (OutputStream)noXmp);
        ByteArrayOutputStream noXmpNoIptc = new ByteArrayOutputStream();
        new JpegIptcRewriter().removeIptc(noXmp.toByteArray(), (OutputStream)noXmpNoIptc);
        return noXmpNoIptc.toByteArray();
    }

    @Test
    public void testRewrite() throws Exception {
        byte[] imageWithExif = this.cleanImage(this.getImageWithExifData());
        TiffImageMetadata metadata = this.toTiffMetadata(Imaging.getMetadata((byte[])imageWithExif));
        ExifRewriter rewriter = new ExifRewriter();
        TiffOutputSet outputSet = metadata.getOutputSet();
        TiffOutputDirectory root = outputSet.getOrCreateRootDirectory();
        root.removeField((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION);
        root.removeField((TagInfo)TiffTagConstants.TIFF_TAG_ARTIST);
        root.removeField((TagInfo)MicrosoftTagConstants.EXIF_TAG_XPAUTHOR);
        root.add(MicrosoftTagConstants.EXIF_TAG_XPAUTHOR, AUTHOR);
        root.removeField((TagInfo)MicrosoftTagConstants.EXIF_TAG_XPCOMMENT);
        root.add(MicrosoftTagConstants.EXIF_TAG_XPCOMMENT, COMMENT);
        root.removeField((TagInfo)MicrosoftTagConstants.EXIF_TAG_XPSUBJECT);
        root.add(MicrosoftTagConstants.EXIF_TAG_XPSUBJECT, SUBJECT);
        root.removeField((TagInfo)MicrosoftTagConstants.EXIF_TAG_XPTITLE);
        root.add(MicrosoftTagConstants.EXIF_TAG_XPTITLE, TITLE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        rewriter.updateExifMetadataLossy(imageWithExif, (OutputStream)baos, outputSet);
        this.checkFields(baos.toByteArray());
    }

    @Test
    public void testWrite() throws Exception {
        byte[] bytes;
        BufferedImage image = new BufferedImage(10, 10, 2);
        TiffOutputSet exifSet = new TiffOutputSet();
        TiffOutputDirectory root = exifSet.getOrCreateRootDirectory();
        root.add(MicrosoftTagConstants.EXIF_TAG_XPAUTHOR, AUTHOR);
        root.add(MicrosoftTagConstants.EXIF_TAG_XPCOMMENT, COMMENT);
        root.add(MicrosoftTagConstants.EXIF_TAG_XPSUBJECT, SUBJECT);
        root.add(MicrosoftTagConstants.EXIF_TAG_XPTITLE, TITLE);
        TiffImagingParameters params = new TiffImagingParameters();
        params.setOutputSet(exifSet);
        TiffImageParser tiffImageParser = new TiffImageParser();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            tiffImageParser.writeImage(image, (OutputStream)baos, params);
            bytes = baos.toByteArray();
        }
        this.checkFields(bytes);
    }

    private TiffImageMetadata toTiffMetadata(ImageMetadata metadata) throws Exception {
        if (metadata instanceof JpegImageMetadata) {
            return ((JpegImageMetadata)metadata).getExif();
        }
        if (metadata instanceof TiffImageMetadata) {
            return (TiffImageMetadata)metadata;
        }
        throw new Exception("bad metadata format");
    }
}

