/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.ElementModifier;
import org.dom4j.io.ElementStack;
import org.dom4j.io.SAXModifyException;

class SAXModifyElementHandler
implements ElementHandler {
    private ElementModifier elemModifier;
    private Element modifiedElement;

    public SAXModifyElementHandler(ElementModifier elemModifier) {
        this.elemModifier = elemModifier;
    }

    public void onStart(ElementPath elementPath) {
        this.modifiedElement = elementPath.getCurrent();
    }

    public void onEnd(ElementPath elementPath) {
        try {
            Element clonedElem;
            Element originalElement = elementPath.getCurrent();
            Element currentParent = originalElement.getParent();
            if (currentParent != null) {
                clonedElem = (Element)originalElement.clone();
                this.modifiedElement = this.elemModifier.modifyElement(clonedElem);
                if (this.modifiedElement != null) {
                    this.modifiedElement.setParent(originalElement.getParent());
                    this.modifiedElement.setDocument(originalElement.getDocument());
                    int contentIndex = currentParent.indexOf(originalElement);
                    currentParent.content().set(contentIndex, this.modifiedElement);
                }
                originalElement.detach();
            } else if (originalElement.isRootElement()) {
                clonedElem = (Element)originalElement.clone();
                this.modifiedElement = this.elemModifier.modifyElement(clonedElem);
                if (this.modifiedElement != null) {
                    this.modifiedElement.setDocument(originalElement.getDocument());
                    originalElement.getDocument().setRootElement(this.modifiedElement);
                }
                originalElement.detach();
            }
            if (elementPath instanceof ElementStack) {
                ElementStack elementStack = (ElementStack)elementPath;
                elementStack.popElement();
                elementStack.pushElement(this.modifiedElement);
            }
        }
        catch (Exception ex) {
            throw new SAXModifyException(ex);
        }
    }

    protected Element getModifiedElement() {
        return this.modifiedElement;
    }
}

