/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.DifferentiableMultivariateFunction;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.function.Add;
import org.apache.commons.math3.analysis.function.Constant;
import org.apache.commons.math3.analysis.function.Cos;
import org.apache.commons.math3.analysis.function.Cosh;
import org.apache.commons.math3.analysis.function.Divide;
import org.apache.commons.math3.analysis.function.Identity;
import org.apache.commons.math3.analysis.function.Inverse;
import org.apache.commons.math3.analysis.function.Log;
import org.apache.commons.math3.analysis.function.Max;
import org.apache.commons.math3.analysis.function.Min;
import org.apache.commons.math3.analysis.function.Minus;
import org.apache.commons.math3.analysis.function.Multiply;
import org.apache.commons.math3.analysis.function.Pow;
import org.apache.commons.math3.analysis.function.Power;
import org.apache.commons.math3.analysis.function.Sin;
import org.apache.commons.math3.analysis.function.Sinc;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class FunctionUtilsTest {
    private final double EPS = FastMath.ulp((double)1.0);

    @Test
    public void testCompose() {
        Identity id = new Identity();
        Assert.assertEquals((double)3.0, (double)FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{id, id, id}).value(3.0), (double)this.EPS);
        Constant c = new Constant(4.0);
        Assert.assertEquals((double)4.0, (double)FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{id, c}).value(3.0), (double)this.EPS);
        Assert.assertEquals((double)4.0, (double)FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{c, id}).value(3.0), (double)this.EPS);
        Minus m = new Minus();
        Assert.assertEquals((double)-3.0, (double)FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{m}).value(3.0), (double)this.EPS);
        Assert.assertEquals((double)3.0, (double)FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{m, m}).value(3.0), (double)this.EPS);
        Inverse inv = new Inverse();
        Assert.assertEquals((double)-0.25, (double)FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{inv, m, c, id}).value(3.0), (double)this.EPS);
        Power pow = new Power(2.0);
        Assert.assertEquals((double)81.0, (double)FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{pow, pow}).value(3.0), (double)this.EPS);
    }

    @Test
    public void testComposeDifferentiable() {
        Identity id = new Identity();
        Assert.assertEquals((double)1.0, (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{id, id, id}).value(new DerivativeStructure(1, 1, 0, 3.0)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Constant c = new Constant(4.0);
        Assert.assertEquals((double)0.0, (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{id, c}).value(new DerivativeStructure(1, 1, 0, 3.0)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Assert.assertEquals((double)0.0, (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{c, id}).value(new DerivativeStructure(1, 1, 0, 3.0)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Minus m = new Minus();
        Assert.assertEquals((double)-1.0, (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{m}).value(new DerivativeStructure(1, 1, 0, 3.0)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Assert.assertEquals((double)1.0, (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{m, m}).value(new DerivativeStructure(1, 1, 0, 3.0)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Inverse inv = new Inverse();
        Assert.assertEquals((double)0.25, (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{inv, m, id}).value(new DerivativeStructure(1, 1, 0, 2.0)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Power pow = new Power(2.0);
        Assert.assertEquals((double)108.0, (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{pow, pow}).value(new DerivativeStructure(1, 1, 0, 3.0)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Log log = new Log();
        double a = 9876.54321;
        Assert.assertEquals((double)(pow.value(new DerivativeStructure(1, 1, 0, a)).getPartialDerivative(new int[]{1}) / pow.value(a)), (double)FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{log, pow}).value(new DerivativeStructure(1, 1, 0, a)).getPartialDerivative(new int[]{1}), (double)this.EPS);
    }

    @Test
    public void testAdd() {
        Identity id = new Identity();
        Constant c = new Constant(4.0);
        Minus m = new Minus();
        Inverse inv = new Inverse();
        Assert.assertEquals((double)4.5, (double)FunctionUtils.add((UnivariateFunction[])new UnivariateFunction[]{inv, m, c, id}).value(2.0), (double)this.EPS);
        Assert.assertEquals((double)6.0, (double)FunctionUtils.add((UnivariateFunction[])new UnivariateFunction[]{c, id}).value(2.0), (double)this.EPS);
        Assert.assertEquals((double)2.0, (double)FunctionUtils.add((UnivariateFunction[])new UnivariateFunction[]{c, FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{m, id})}).value(2.0), (double)this.EPS);
    }

    @Test
    public void testAddDifferentiable() {
        Sin sin = new Sin();
        Constant c = new Constant(4.0);
        Minus m = new Minus();
        Inverse inv = new Inverse();
        double a = 123.456;
        Assert.assertEquals((double)(-1.000065610839816 + FastMath.cos((double)123.456)), (double)FunctionUtils.add((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{inv, m, c, sin}).value(new DerivativeStructure(1, 1, 0, 123.456)).getPartialDerivative(new int[]{1}), (double)this.EPS);
    }

    @Test
    public void testMultiply() {
        Constant c = new Constant(4.0);
        Assert.assertEquals((double)16.0, (double)FunctionUtils.multiply((UnivariateFunction[])new UnivariateFunction[]{c, c}).value(12345.0), (double)this.EPS);
        Inverse inv = new Inverse();
        Power pow = new Power(2.0);
        Assert.assertEquals((double)1.0, (double)FunctionUtils.multiply((UnivariateFunction[])new UnivariateFunction[]{FunctionUtils.compose((UnivariateFunction[])new UnivariateFunction[]{inv, pow}), pow}).value(3.5), (double)this.EPS);
    }

    @Test
    public void testMultiplyDifferentiable() {
        Constant c = new Constant(4.0);
        Identity id = new Identity();
        double a = 1.2345678;
        Assert.assertEquals((double)9.8765424, (double)FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{c, id, id}).value(new DerivativeStructure(1, 1, 0, 1.2345678)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Inverse inv = new Inverse();
        Power pow = new Power(2.5);
        Cos cos = new Cos();
        Assert.assertEquals((double)(1.5 * FastMath.sqrt((double)1.2345678) * FastMath.cos((double)1.2345678) - FastMath.pow((double)1.2345678, (double)1.5) * FastMath.sin((double)1.2345678)), (double)FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{inv, pow, cos}).value(new DerivativeStructure(1, 1, 0, 1.2345678)).getPartialDerivative(new int[]{1}), (double)this.EPS);
        Cosh cosh = new Cosh();
        Assert.assertEquals((double)(1.5 * FastMath.sqrt((double)1.2345678) * FastMath.cosh((double)1.2345678) + FastMath.pow((double)1.2345678, (double)1.5) * FastMath.sinh((double)1.2345678)), (double)FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{inv, pow, cosh}).value(new DerivativeStructure(1, 1, 0, 1.2345678)).getPartialDerivative(new int[]{1}), (double)(8.0 * this.EPS));
    }

    @Test
    public void testCombine() {
        Add bi = new Add();
        Identity id = new Identity();
        Minus m = new Minus();
        UnivariateFunction c = FunctionUtils.combine((BivariateFunction)bi, (UnivariateFunction)id, (UnivariateFunction)m);
        Assert.assertEquals((double)0.0, (double)c.value(2.3456), (double)this.EPS);
        bi = new Multiply();
        Inverse inv = new Inverse();
        c = FunctionUtils.combine((BivariateFunction)bi, (UnivariateFunction)id, (UnivariateFunction)inv);
        Assert.assertEquals((double)1.0, (double)c.value(2.3456), (double)this.EPS);
    }

    @Test
    public void testCollector() {
        Add bi = new Add();
        MultivariateFunction coll = FunctionUtils.collector((BivariateFunction)bi, (double)0.0);
        Assert.assertEquals((double)10.0, (double)coll.value(new double[]{1.0, 2.0, 3.0, 4.0}), (double)this.EPS);
        bi = new Multiply();
        coll = FunctionUtils.collector((BivariateFunction)bi, (double)1.0);
        Assert.assertEquals((double)24.0, (double)coll.value(new double[]{1.0, 2.0, 3.0, 4.0}), (double)this.EPS);
        bi = new Max();
        coll = FunctionUtils.collector((BivariateFunction)bi, (double)Double.NEGATIVE_INFINITY);
        Assert.assertEquals((double)10.0, (double)coll.value(new double[]{1.0, -2.0, 7.5, 10.0, -24.0, 9.99}), (double)0.0);
        bi = new Min();
        coll = FunctionUtils.collector((BivariateFunction)bi, (double)Double.POSITIVE_INFINITY);
        Assert.assertEquals((double)-24.0, (double)coll.value(new double[]{1.0, -2.0, 7.5, 10.0, -24.0, 9.99}), (double)0.0);
    }

    @Test
    public void testSinc() {
        Divide div = new Divide();
        Sin sin = new Sin();
        Identity id = new Identity();
        UnivariateFunction sinc1 = FunctionUtils.combine((BivariateFunction)div, (UnivariateFunction)sin, (UnivariateFunction)id);
        Sinc sinc2 = new Sinc();
        for (int i = 0; i < 10; ++i) {
            double x = FastMath.random();
            Assert.assertEquals((double)sinc1.value(x), (double)sinc2.value(x), (double)this.EPS);
        }
    }

    @Test
    public void testFixingArguments() {
        UnivariateFunction scaler = FunctionUtils.fix1stArgument((BivariateFunction)new Multiply(), (double)10.0);
        Assert.assertEquals((double)1.23456, (double)scaler.value(0.123456), (double)this.EPS);
        Power pow1 = new Power(2.0);
        UnivariateFunction pow2 = FunctionUtils.fix2ndArgument((BivariateFunction)new Pow(), (double)2.0);
        for (int i = 0; i < 10; ++i) {
            double x = FastMath.random() * 10.0;
            Assert.assertEquals((double)pow1.value(x), (double)pow2.value(x), (double)0.0);
        }
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testSampleWrongBounds() {
        FunctionUtils.sample((UnivariateFunction)new Sin(), (double)Math.PI, (double)0.0, (int)10);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testSampleNegativeNumberOfPoints() {
        FunctionUtils.sample((UnivariateFunction)new Sin(), (double)0.0, (double)Math.PI, (int)-1);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testSampleNullNumberOfPoints() {
        FunctionUtils.sample((UnivariateFunction)new Sin(), (double)0.0, (double)Math.PI, (int)0);
    }

    @Test
    public void testSample() {
        int n = 11;
        double min = 0.0;
        double max = Math.PI;
        double[] actual = FunctionUtils.sample((UnivariateFunction)new Sin(), (double)0.0, (double)Math.PI, (int)11);
        for (int i = 0; i < 11; ++i) {
            double x = 0.0 + 0.28559933214452665 * (double)i;
            Assert.assertEquals((String)("x = " + x), (double)FastMath.sin((double)x), (double)actual[i], (double)0.0);
        }
    }

    @Test
    @Deprecated
    public void testToDifferentiableUnivariateFunction() {
        Sin sin = new Sin();
        DifferentiableUnivariateFunction converted = FunctionUtils.toDifferentiableUnivariateFunction((UnivariateDifferentiableFunction)sin);
        for (double x = 0.1; x < 0.5; x += 0.01) {
            Assert.assertEquals((double)sin.value(x), (double)converted.value(x), (double)1.0E-10);
            Assert.assertEquals((double)sin.derivative().value(x), (double)converted.derivative().value(x), (double)1.0E-10);
        }
    }

    @Test
    @Deprecated
    public void testToUnivariateDifferential() {
        Sin sin = new Sin();
        UnivariateDifferentiableFunction converted = FunctionUtils.toUnivariateDifferential((DifferentiableUnivariateFunction)sin);
        for (double x = 0.1; x < 0.5; x += 0.01) {
            DerivativeStructure t = new DerivativeStructure(2, 1, new double[]{x, 1.0, 2.0});
            Assert.assertEquals((double)sin.value(t).getValue(), (double)converted.value(t).getValue(), (double)1.0E-10);
            Assert.assertEquals((double)sin.value(t).getPartialDerivative(new int[]{1, 0}), (double)converted.value(t).getPartialDerivative(new int[]{1, 0}), (double)1.0E-10);
            Assert.assertEquals((double)sin.value(t).getPartialDerivative(new int[]{0, 1}), (double)converted.value(t).getPartialDerivative(new int[]{0, 1}), (double)1.0E-10);
        }
    }

    @Test
    @Deprecated
    public void testToDifferentiableMultivariateFunction() {
        MultivariateDifferentiableFunction hypot = new MultivariateDifferentiableFunction(){

            public double value(double[] point) {
                return FastMath.hypot((double)point[0], (double)point[1]);
            }

            public DerivativeStructure value(DerivativeStructure[] point) {
                return DerivativeStructure.hypot((DerivativeStructure)point[0], (DerivativeStructure)point[1]);
            }
        };
        DifferentiableMultivariateFunction converted = FunctionUtils.toDifferentiableMultivariateFunction((MultivariateDifferentiableFunction)hypot);
        for (double x = 0.1; x < 0.5; x += 0.01) {
            for (double y = 0.1; y < 0.5; y += 0.01) {
                double[] point = new double[]{x, y};
                Assert.assertEquals((double)hypot.value(point), (double)converted.value(point), (double)1.0E-10);
                Assert.assertEquals((double)(x / hypot.value(point)), (double)converted.gradient().value(point)[0], (double)1.0E-10);
                Assert.assertEquals((double)(y / hypot.value(point)), (double)converted.gradient().value(point)[1], (double)1.0E-10);
            }
        }
    }

    @Test
    @Deprecated
    public void testToMultivariateDifferentiableFunction() {
        DifferentiableMultivariateFunction hypot = new DifferentiableMultivariateFunction(){

            public double value(double[] point) {
                return FastMath.hypot((double)point[0], (double)point[1]);
            }

            public MultivariateFunction partialDerivative(final int k) {
                return new MultivariateFunction(){

                    public double value(double[] point) {
                        return point[k] / FastMath.hypot((double)point[0], (double)point[1]);
                    }
                };
            }

            public MultivariateVectorFunction gradient() {
                return new MultivariateVectorFunction(){

                    public double[] value(double[] point) {
                        double h = FastMath.hypot((double)point[0], (double)point[1]);
                        return new double[]{point[0] / h, point[1] / h};
                    }
                };
            }
        };
        MultivariateDifferentiableFunction converted = FunctionUtils.toMultivariateDifferentiableFunction((DifferentiableMultivariateFunction)hypot);
        for (double x = 0.1; x < 0.5; x += 0.01) {
            for (double y = 0.1; y < 0.5; y += 0.01) {
                DerivativeStructure[] t = new DerivativeStructure[]{new DerivativeStructure(3, 1, new double[]{x, 1.0, 2.0, 3.0}), new DerivativeStructure(3, 1, new double[]{y, 4.0, 5.0, 6.0})};
                DerivativeStructure h = DerivativeStructure.hypot((DerivativeStructure)t[0], (DerivativeStructure)t[1]);
                Assert.assertEquals((double)h.getValue(), (double)converted.value(t).getValue(), (double)1.0E-10);
                Assert.assertEquals((double)h.getPartialDerivative(new int[]{1, 0, 0}), (double)converted.value(t).getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-10);
                Assert.assertEquals((double)h.getPartialDerivative(new int[]{0, 1, 0}), (double)converted.value(t).getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-10);
                Assert.assertEquals((double)h.getPartialDerivative(new int[]{0, 0, 1}), (double)converted.value(t).getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-10);
            }
        }
    }
}

