/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.LaplaceDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class LaplaceDistributionTest
extends RealDistributionAbstractTest {
    @Test
    public void testParameters() {
        LaplaceDistribution d = this.makeDistribution();
        Assert.assertEquals((double)0.0, (double)d.getLocation(), (double)Precision.EPSILON);
        Assert.assertEquals((double)1.0, (double)d.getScale(), (double)Precision.EPSILON);
    }

    @Test
    public void testSupport() {
        LaplaceDistribution d = this.makeDistribution();
        Assert.assertTrue((boolean)Double.isInfinite(d.getSupportLowerBound()));
        Assert.assertTrue((boolean)Double.isInfinite(d.getSupportUpperBound()));
        Assert.assertTrue((boolean)d.isSupportConnected());
    }

    public LaplaceDistribution makeDistribution() {
        return new LaplaceDistribution(0.0, 1.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.003368973, 0.009157819, 0.024893534, 0.067667642, 0.183939721, 0.5, 0.183939721, 0.067667642, 0.024893534, 0.009157819, 0.003368973};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.003368973, 0.009157819, 0.024893534, 0.067667642, 0.183939721, 0.5, 0.816060279, 0.932332358, 0.975106466, 0.990842181, 0.996631027};
    }
}

