/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.summary;

import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import org.junit.Assert;
import org.junit.Test;

public class SumSqTest
extends StorelessUnivariateStatisticAbstractTest {
    protected SumOfSquares stat;

    public UnivariateStatistic getUnivariateStatistic() {
        return new SumOfSquares();
    }

    public double expectedValue() {
        return this.sumSq;
    }

    @Test
    public void testSpecialValues() {
        SumOfSquares sumSq = new SumOfSquares();
        Assert.assertEquals((double)0.0, (double)sumSq.getResult(), (double)0.0);
        sumSq.increment(2.0);
        Assert.assertEquals((double)4.0, (double)sumSq.getResult(), (double)0.0);
        sumSq.increment(Double.POSITIVE_INFINITY);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)sumSq.getResult(), (double)0.0);
        sumSq.increment(Double.NEGATIVE_INFINITY);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)sumSq.getResult(), (double)0.0);
        sumSq.increment(Double.NaN);
        Assert.assertTrue((boolean)Double.isNaN(sumSq.getResult()));
        sumSq.increment(1.0);
        Assert.assertTrue((boolean)Double.isNaN(sumSq.getResult()));
    }

    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assert.assertEquals((double)0.0, (double)statistic.getResult(), (double)0.0);
    }
}

