/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class PairTest {
    @Test
    public void testAccessor() {
        Pair p = new Pair((Object)new Integer(1), (Object)new Double(2.0));
        Assert.assertEquals((Object)new Integer(1), (Object)p.getKey());
        Assert.assertEquals((double)2.0, (double)((Double)p.getValue()), (double)Math.ulp(1.0));
    }

    @Test
    public void testAccessor2() {
        Pair p = new Pair((Object)new Integer(1), (Object)new Double(2.0));
        Assert.assertTrue((p.getFirst() == p.getKey() ? 1 : 0) != 0);
        Assert.assertTrue((p.getSecond() == p.getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Pair p1 = new Pair(null, null);
        Assert.assertFalse((boolean)p1.equals(null));
        Pair p2 = new Pair(null, null);
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        p1 = new Pair((Object)new Integer(1), (Object)new Double(2.0));
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        p2 = new Pair((Object)new Integer(1), (Object)new Double(2.0));
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Pair p3 = new Pair((Object)new Integer(1), (Object)new Float(2.0f));
        Assert.assertFalse((boolean)p1.equals((Object)p3));
    }

    @Test
    public void testHashCode() {
        MyInteger m1 = new MyInteger(1);
        MyInteger m2 = new MyInteger(1);
        Pair p1 = new Pair((Object)m1, (Object)m1);
        Pair p2 = new Pair((Object)m2, (Object)m2);
        Assert.assertTrue((p1.hashCode() == p2.hashCode() ? 1 : 0) != 0);
        m2.set(2);
        Assert.assertFalse((p1.hashCode() == p2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"[null, null]", (Object)new Pair(null, null).toString());
        Assert.assertEquals((Object)"[foo, 3]", (Object)new Pair((Object)"foo", (Object)3).toString());
    }

    @Test
    public void testCreate() {
        Pair p1 = Pair.create((Object)"foo", (Object)3);
        Assert.assertNotNull((Object)p1);
        Pair p2 = new Pair((Object)"foo", (Object)3);
        Assert.assertEquals((Object)p2, (Object)p1);
    }

    private static class MyInteger {
        private int i;

        public MyInteger(int i) {
            this.i = i;
        }

        public void set(int i) {
            this.i = i;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MyInteger)) {
                return false;
            }
            return this.i == ((MyInteger)o).i;
        }

        public int hashCode() {
            return this.i;
        }
    }
}

