/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.rootfinder;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.numbers.rootfinder.SolverException;

public class BrentSolver {
    private final double relativeAccuracy;
    private final double absoluteAccuracy;
    private final double functionValueAccuracy;

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        this.relativeAccuracy = relativeAccuracy;
        this.absoluteAccuracy = absoluteAccuracy;
        this.functionValueAccuracy = functionValueAccuracy;
    }

    public double findRoot(DoubleUnaryOperator func, double min, double max) {
        double initial = min == max ? min : 0.5 * min + 0.5 * max;
        return this.findRoot(func, min, initial, max);
    }

    public double findRoot(DoubleUnaryOperator func, double min, double initial, double max) {
        if (min > max) {
            throw new SolverException("%s > %s", min, max);
        }
        if (initial < min || initial > max) {
            throw new SolverException("%s is out of range [%s, %s]", initial, min, max);
        }
        double yInitial = func.applyAsDouble(initial);
        if (Math.abs(yInitial) <= this.functionValueAccuracy) {
            return initial;
        }
        double yMin = func.applyAsDouble(min);
        if (Math.abs(yMin) <= this.functionValueAccuracy) {
            return min;
        }
        if (Double.compare(yInitial * yMin, 0.0) < 0) {
            return this.brent(func, min, initial, yMin, yInitial);
        }
        double yMax = func.applyAsDouble(max);
        if (Math.abs(yMax) <= this.functionValueAccuracy) {
            return max;
        }
        if (Double.compare(yInitial * yMax, 0.0) < 0) {
            return this.brent(func, initial, max, yInitial, yMax);
        }
        throw new SolverException("No bracketing: f(%s)=%s, f(%s)=%s", min, yMin, max, yMax);
    }

    private double brent(DoubleUnaryOperator func, double lo, double hi, double fLo, double fHi) {
        double d;
        double a = lo;
        double fa = fLo;
        double b = hi;
        double fb = fHi;
        double c = a;
        double fc = fa;
        double e = d = b - a;
        double t = this.absoluteAccuracy;
        double eps = this.relativeAccuracy;
        while (true) {
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol = 2.0 * eps * Math.abs(b) + t;
            double m = 0.5 * (c - b);
            if (Math.abs(m) <= tol || BrentSolver.equalsZero(fb)) {
                return b;
            }
            if (Math.abs(e) < tol || Math.abs(fa) <= Math.abs(fb)) {
                e = d = m;
            } else {
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * m * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * m * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                if (p >= 1.5 * m * q - Math.abs(tol * q) || p >= Math.abs(0.5 * e * q)) {
                    e = d = m;
                } else {
                    e = d;
                    d = p / q;
                }
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol ? (b += d) : (m > 0.0 ? (b += tol) : (b -= tol));
            fb = func.applyAsDouble(b);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb <= 0.0) || !(fc <= 0.0))) continue;
            c = a;
            fc = fa;
            e = d = b - a;
        }
    }

    private static boolean equalsZero(double value) {
        return Math.abs(value) <= Double.MIN_VALUE;
    }
}

