/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.TransitionTarget;

public class Path
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List upSeg = new ArrayList();
    private List downSeg = new ArrayList();
    private TransitionTarget scope = null;
    private boolean crossRegion = false;

    Path(TransitionTarget source, TransitionTarget target) {
        if (target == null) {
            this.scope = source;
        } else {
            State st;
            TransitionTarget tt = SCXMLHelper.getLCA(source, target);
            if (tt != null) {
                this.scope = tt;
                if (this.scope == source || this.scope == target) {
                    this.scope = this.scope.getParent();
                }
            }
            for (tt = source; tt != this.scope; tt = tt.getParent()) {
                this.upSeg.add(tt);
                if (!(tt instanceof State) || !(st = (State)tt).isRegion()) continue;
                this.crossRegion = true;
            }
            for (tt = target; tt != this.scope; tt = tt.getParent()) {
                this.downSeg.add(0, tt);
                if (!(tt instanceof State) || !(st = (State)tt).isRegion()) continue;
                this.crossRegion = true;
            }
        }
    }

    public final boolean isCrossRegion() {
        return this.crossRegion;
    }

    public final List getRegionsExited() {
        LinkedList<State> ll = new LinkedList<State>();
        Iterator i = this.upSeg.iterator();
        while (i.hasNext()) {
            State st;
            Object o = i.next();
            if (!(o instanceof State) || !(st = (State)o).isRegion()) continue;
            ll.add(st);
        }
        return ll;
    }

    public final List getRegionsEntered() {
        LinkedList<State> ll = new LinkedList<State>();
        Iterator i = this.downSeg.iterator();
        while (i.hasNext()) {
            State st;
            Object o = i.next();
            if (!(o instanceof State) || !(st = (State)o).isRegion()) continue;
            ll.add(st);
        }
        return ll;
    }

    public final State getScope() {
        if (this.scope instanceof State) {
            return (State)this.scope;
        }
        return null;
    }

    public final TransitionTarget getPathScope() {
        return this.scope;
    }

    public final List getUpwardSegment() {
        return this.upSeg;
    }

    public final List getDownwardSegment() {
        return this.downSeg;
    }
}

